// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Environment type is either user created or curated by Azure ML service. </summary>
    public readonly partial struct MachineLearningEnvironmentType : IEquatable<MachineLearningEnvironmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEnvironmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningEnvironmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CuratedValue = "Curated";
        private const string UserCreatedValue = "UserCreated";

        /// <summary> Curated. </summary>
        public static MachineLearningEnvironmentType Curated { get; } = new MachineLearningEnvironmentType(CuratedValue);
        /// <summary> UserCreated. </summary>
        public static MachineLearningEnvironmentType UserCreated { get; } = new MachineLearningEnvironmentType(UserCreatedValue);
        /// <summary> Determines if two <see cref="MachineLearningEnvironmentType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningEnvironmentType left, MachineLearningEnvironmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningEnvironmentType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningEnvironmentType left, MachineLearningEnvironmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningEnvironmentType"/>. </summary>
        public static implicit operator MachineLearningEnvironmentType(string value) => new MachineLearningEnvironmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningEnvironmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningEnvironmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
