// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> State of endpoint provisioning. </summary>
    public readonly partial struct MachineLearningEndpointProvisioningState : IEquatable<MachineLearningEndpointProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEndpointProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningEndpointProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string UpdatingValue = "Updating";
        private const string CanceledValue = "Canceled";

        /// <summary> Creating. </summary>
        public static MachineLearningEndpointProvisioningState Creating { get; } = new MachineLearningEndpointProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static MachineLearningEndpointProvisioningState Deleting { get; } = new MachineLearningEndpointProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static MachineLearningEndpointProvisioningState Succeeded { get; } = new MachineLearningEndpointProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static MachineLearningEndpointProvisioningState Failed { get; } = new MachineLearningEndpointProvisioningState(FailedValue);
        /// <summary> Updating. </summary>
        public static MachineLearningEndpointProvisioningState Updating { get; } = new MachineLearningEndpointProvisioningState(UpdatingValue);
        /// <summary> Canceled. </summary>
        public static MachineLearningEndpointProvisioningState Canceled { get; } = new MachineLearningEndpointProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="MachineLearningEndpointProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MachineLearningEndpointProvisioningState left, MachineLearningEndpointProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningEndpointProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningEndpointProvisioningState left, MachineLearningEndpointProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningEndpointProvisioningState"/>. </summary>
        public static implicit operator MachineLearningEndpointProvisioningState(string value) => new MachineLearningEndpointProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningEndpointProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningEndpointProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
