// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Base definition for endpoint deployment. </summary>
    public partial class MachineLearningEndpointDeploymentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEndpointDeploymentProperties"/>. </summary>
        public MachineLearningEndpointDeploymentProperties()
        {
            Properties = new ChangeTrackingDictionary<string, string>();
            EnvironmentVariables = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningEndpointDeploymentProperties"/>. </summary>
        /// <param name="description"> Description of the endpoint deployment. </param>
        /// <param name="properties"> Property dictionary. Properties can be added, but not removed or altered. </param>
        /// <param name="codeConfiguration"> Code configuration for the endpoint deployment. </param>
        /// <param name="environmentId"> ARM resource ID or AssetId of the environment specification for the endpoint deployment. </param>
        /// <param name="environmentVariables"> Environment variables configuration for the deployment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningEndpointDeploymentProperties(string description, IDictionary<string, string> properties, MachineLearningCodeConfiguration codeConfiguration, string environmentId, IDictionary<string, string> environmentVariables, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            Properties = properties;
            CodeConfiguration = codeConfiguration;
            EnvironmentId = environmentId;
            EnvironmentVariables = environmentVariables;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Description of the endpoint deployment. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Property dictionary. Properties can be added, but not removed or altered. </summary>
        [WirePath("properties")]
        public IDictionary<string, string> Properties { get; set; }
        /// <summary> Code configuration for the endpoint deployment. </summary>
        [WirePath("codeConfiguration")]
        public MachineLearningCodeConfiguration CodeConfiguration { get; set; }
        /// <summary> ARM resource ID or AssetId of the environment specification for the endpoint deployment. </summary>
        [WirePath("environmentId")]
        public string EnvironmentId { get; set; }
        /// <summary> Environment variables configuration for the deployment. </summary>
        [WirePath("environmentVariables")]
        public IDictionary<string, string> EnvironmentVariables { get; set; }
    }
}
