// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine endpoint compute type. </summary>
    public readonly partial struct MachineLearningEndpointComputeType : IEquatable<MachineLearningEndpointComputeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEndpointComputeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningEndpointComputeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManagedValue = "Managed";
        private const string KubernetesValue = "Kubernetes";
        private const string AmlComputeValue = "AzureMLCompute";

        /// <summary> Managed. </summary>
        public static MachineLearningEndpointComputeType Managed { get; } = new MachineLearningEndpointComputeType(ManagedValue);
        /// <summary> Kubernetes. </summary>
        public static MachineLearningEndpointComputeType Kubernetes { get; } = new MachineLearningEndpointComputeType(KubernetesValue);
        /// <summary> AzureMLCompute. </summary>
        public static MachineLearningEndpointComputeType AmlCompute { get; } = new MachineLearningEndpointComputeType(AmlComputeValue);
        /// <summary> Determines if two <see cref="MachineLearningEndpointComputeType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningEndpointComputeType left, MachineLearningEndpointComputeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningEndpointComputeType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningEndpointComputeType left, MachineLearningEndpointComputeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningEndpointComputeType"/>. </summary>
        public static implicit operator MachineLearningEndpointComputeType(string value) => new MachineLearningEndpointComputeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningEndpointComputeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningEndpointComputeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
