// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine endpoint authentication mode. </summary>
    public readonly partial struct MachineLearningEndpointAuthMode : IEquatable<MachineLearningEndpointAuthMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEndpointAuthMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningEndpointAuthMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AmlTokenValue = "AMLToken";
        private const string KeyValue = "Key";
        private const string AadTokenValue = "AADToken";

        /// <summary> AMLToken. </summary>
        public static MachineLearningEndpointAuthMode AmlToken { get; } = new MachineLearningEndpointAuthMode(AmlTokenValue);
        /// <summary> Key. </summary>
        public static MachineLearningEndpointAuthMode Key { get; } = new MachineLearningEndpointAuthMode(KeyValue);
        /// <summary> AADToken. </summary>
        public static MachineLearningEndpointAuthMode AadToken { get; } = new MachineLearningEndpointAuthMode(AadTokenValue);
        /// <summary> Determines if two <see cref="MachineLearningEndpointAuthMode"/> values are the same. </summary>
        public static bool operator ==(MachineLearningEndpointAuthMode left, MachineLearningEndpointAuthMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningEndpointAuthMode"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningEndpointAuthMode left, MachineLearningEndpointAuthMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningEndpointAuthMode"/>. </summary>
        public static implicit operator MachineLearningEndpointAuthMode(string value) => new MachineLearningEndpointAuthMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningEndpointAuthMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningEndpointAuthMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
