// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Indicates whether or not the encryption is enabled for the workspace. </summary>
    public readonly partial struct MachineLearningEncryptionStatus : IEquatable<MachineLearningEncryptionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEncryptionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningEncryptionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static MachineLearningEncryptionStatus Enabled { get; } = new MachineLearningEncryptionStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static MachineLearningEncryptionStatus Disabled { get; } = new MachineLearningEncryptionStatus(DisabledValue);
        /// <summary> Determines if two <see cref="MachineLearningEncryptionStatus"/> values are the same. </summary>
        public static bool operator ==(MachineLearningEncryptionStatus left, MachineLearningEncryptionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningEncryptionStatus"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningEncryptionStatus left, MachineLearningEncryptionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningEncryptionStatus"/>. </summary>
        public static implicit operator MachineLearningEncryptionStatus(string value) => new MachineLearningEncryptionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningEncryptionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningEncryptionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
