// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningEncryptionSetting. </summary>
    public partial class MachineLearningEncryptionSetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEncryptionSetting"/>. </summary>
        /// <param name="status"> Indicates whether or not the encryption is enabled for the workspace. </param>
        /// <param name="identity"> The identity that will be used to access the key vault for encryption at rest. </param>
        /// <param name="keyVaultProperties"> Customer Key vault properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningEncryptionSetting(MachineLearningEncryptionStatus status, MachineLearningCmkIdentity identity, MachineLearningEncryptionKeyVaultProperties keyVaultProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Identity = identity;
            KeyVaultProperties = keyVaultProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningEncryptionSetting"/> for deserialization. </summary>
        internal MachineLearningEncryptionSetting()
        {
        }

        /// <summary> Indicates whether or not the encryption is enabled for the workspace. </summary>
        [WirePath("status")]
        public MachineLearningEncryptionStatus Status { get; set; }
        /// <summary> The identity that will be used to access the key vault for encryption at rest. </summary>
        internal MachineLearningCmkIdentity Identity { get; set; }
        /// <summary> The ArmId of the user assigned identity that will be used to access the customer managed key vault. </summary>
        [WirePath("identity.userAssignedIdentity")]
        public ResourceIdentifier UserAssignedIdentity
        {
            get => Identity is null ? default : Identity.UserAssignedIdentity;
            set
            {
                if (Identity is null)
                    Identity = new MachineLearningCmkIdentity();
                Identity.UserAssignedIdentity = value;
            }
        }

        /// <summary> Customer Key vault properties. </summary>
        [WirePath("keyVaultProperties")]
        public MachineLearningEncryptionKeyVaultProperties KeyVaultProperties { get; set; }
    }
}
