// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine whether PublicNetworkAccess is Enabled or Disabled for egress of a deployment. </summary>
    public readonly partial struct MachineLearningEgressPublicNetworkAccessType : IEquatable<MachineLearningEgressPublicNetworkAccessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningEgressPublicNetworkAccessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningEgressPublicNetworkAccessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static MachineLearningEgressPublicNetworkAccessType Enabled { get; } = new MachineLearningEgressPublicNetworkAccessType(EnabledValue);
        /// <summary> Disabled. </summary>
        public static MachineLearningEgressPublicNetworkAccessType Disabled { get; } = new MachineLearningEgressPublicNetworkAccessType(DisabledValue);
        /// <summary> Determines if two <see cref="MachineLearningEgressPublicNetworkAccessType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningEgressPublicNetworkAccessType left, MachineLearningEgressPublicNetworkAccessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningEgressPublicNetworkAccessType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningEgressPublicNetworkAccessType left, MachineLearningEgressPublicNetworkAccessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningEgressPublicNetworkAccessType"/>. </summary>
        public static implicit operator MachineLearningEgressPublicNetworkAccessType(string value) => new MachineLearningEgressPublicNetworkAccessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningEgressPublicNetworkAccessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningEgressPublicNetworkAccessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
