// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningDiagnoseResultValue. </summary>
    public partial class MachineLearningDiagnoseResultValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningDiagnoseResultValue"/>. </summary>
        internal MachineLearningDiagnoseResultValue()
        {
            UserDefinedRouteResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            NetworkSecurityRuleResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            ResourceLockResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            DnsResolutionResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            StorageAccountResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            KeyVaultResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            ContainerRegistryResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            ApplicationInsightsResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
            OtherResults = new ChangeTrackingList<MachineLearningDiagnoseResult>();
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningDiagnoseResultValue"/>. </summary>
        /// <param name="userDefinedRouteResults"></param>
        /// <param name="networkSecurityRuleResults"></param>
        /// <param name="resourceLockResults"></param>
        /// <param name="dnsResolutionResults"></param>
        /// <param name="storageAccountResults"></param>
        /// <param name="keyVaultResults"></param>
        /// <param name="containerRegistryResults"></param>
        /// <param name="applicationInsightsResults"></param>
        /// <param name="otherResults"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningDiagnoseResultValue(IReadOnlyList<MachineLearningDiagnoseResult> userDefinedRouteResults, IReadOnlyList<MachineLearningDiagnoseResult> networkSecurityRuleResults, IReadOnlyList<MachineLearningDiagnoseResult> resourceLockResults, IReadOnlyList<MachineLearningDiagnoseResult> dnsResolutionResults, IReadOnlyList<MachineLearningDiagnoseResult> storageAccountResults, IReadOnlyList<MachineLearningDiagnoseResult> keyVaultResults, IReadOnlyList<MachineLearningDiagnoseResult> containerRegistryResults, IReadOnlyList<MachineLearningDiagnoseResult> applicationInsightsResults, IReadOnlyList<MachineLearningDiagnoseResult> otherResults, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserDefinedRouteResults = userDefinedRouteResults;
            NetworkSecurityRuleResults = networkSecurityRuleResults;
            ResourceLockResults = resourceLockResults;
            DnsResolutionResults = dnsResolutionResults;
            StorageAccountResults = storageAccountResults;
            KeyVaultResults = keyVaultResults;
            ContainerRegistryResults = containerRegistryResults;
            ApplicationInsightsResults = applicationInsightsResults;
            OtherResults = otherResults;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the user defined route results. </summary>
        [WirePath("userDefinedRouteResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> UserDefinedRouteResults { get; }
        /// <summary> Gets the network security rule results. </summary>
        [WirePath("networkSecurityRuleResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> NetworkSecurityRuleResults { get; }
        /// <summary> Gets the resource lock results. </summary>
        [WirePath("resourceLockResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> ResourceLockResults { get; }
        /// <summary> Gets the dns resolution results. </summary>
        [WirePath("dnsResolutionResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> DnsResolutionResults { get; }
        /// <summary> Gets the storage account results. </summary>
        [WirePath("storageAccountResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> StorageAccountResults { get; }
        /// <summary> Gets the key vault results. </summary>
        [WirePath("keyVaultResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> KeyVaultResults { get; }
        /// <summary> Gets the container registry results. </summary>
        [WirePath("containerRegistryResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> ContainerRegistryResults { get; }
        /// <summary> Gets the application insights results. </summary>
        [WirePath("applicationInsightsResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> ApplicationInsightsResults { get; }
        /// <summary> Gets the other results. </summary>
        [WirePath("otherResults")]
        public IReadOnlyList<MachineLearningDiagnoseResult> OtherResults { get; }
    }
}
