// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningDiagnoseResultValue : IUtf8JsonSerializable, IJsonModel<MachineLearningDiagnoseResultValue>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningDiagnoseResultValue>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningDiagnoseResultValue>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDiagnoseResultValue>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningDiagnoseResultValue)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(UserDefinedRouteResults))
            {
                writer.WritePropertyName("userDefinedRouteResults"u8);
                writer.WriteStartArray();
                foreach (var item in UserDefinedRouteResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(NetworkSecurityRuleResults))
            {
                writer.WritePropertyName("networkSecurityRuleResults"u8);
                writer.WriteStartArray();
                foreach (var item in NetworkSecurityRuleResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResourceLockResults))
            {
                writer.WritePropertyName("resourceLockResults"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceLockResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DnsResolutionResults))
            {
                writer.WritePropertyName("dnsResolutionResults"u8);
                writer.WriteStartArray();
                foreach (var item in DnsResolutionResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(StorageAccountResults))
            {
                writer.WritePropertyName("storageAccountResults"u8);
                writer.WriteStartArray();
                foreach (var item in StorageAccountResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(KeyVaultResults))
            {
                writer.WritePropertyName("keyVaultResults"u8);
                writer.WriteStartArray();
                foreach (var item in KeyVaultResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ContainerRegistryResults))
            {
                writer.WritePropertyName("containerRegistryResults"u8);
                writer.WriteStartArray();
                foreach (var item in ContainerRegistryResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ApplicationInsightsResults))
            {
                writer.WritePropertyName("applicationInsightsResults"u8);
                writer.WriteStartArray();
                foreach (var item in ApplicationInsightsResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(OtherResults))
            {
                writer.WritePropertyName("otherResults"u8);
                writer.WriteStartArray();
                foreach (var item in OtherResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningDiagnoseResultValue IJsonModel<MachineLearningDiagnoseResultValue>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDiagnoseResultValue>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningDiagnoseResultValue)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningDiagnoseResultValue(document.RootElement, options);
        }

        internal static MachineLearningDiagnoseResultValue DeserializeMachineLearningDiagnoseResultValue(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<MachineLearningDiagnoseResult> userDefinedRouteResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> networkSecurityRuleResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> resourceLockResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> dnsResolutionResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> storageAccountResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> keyVaultResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> containerRegistryResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> applicationInsightsResults = default;
            IReadOnlyList<MachineLearningDiagnoseResult> otherResults = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("userDefinedRouteResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    userDefinedRouteResults = array;
                    continue;
                }
                if (property.NameEquals("networkSecurityRuleResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    networkSecurityRuleResults = array;
                    continue;
                }
                if (property.NameEquals("resourceLockResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    resourceLockResults = array;
                    continue;
                }
                if (property.NameEquals("dnsResolutionResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    dnsResolutionResults = array;
                    continue;
                }
                if (property.NameEquals("storageAccountResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    storageAccountResults = array;
                    continue;
                }
                if (property.NameEquals("keyVaultResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    keyVaultResults = array;
                    continue;
                }
                if (property.NameEquals("containerRegistryResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    containerRegistryResults = array;
                    continue;
                }
                if (property.NameEquals("applicationInsightsResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    applicationInsightsResults = array;
                    continue;
                }
                if (property.NameEquals("otherResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningDiagnoseResult> array = new List<MachineLearningDiagnoseResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningDiagnoseResult.DeserializeMachineLearningDiagnoseResult(item, options));
                    }
                    otherResults = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningDiagnoseResultValue(
                userDefinedRouteResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                networkSecurityRuleResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                resourceLockResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                dnsResolutionResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                storageAccountResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                keyVaultResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                containerRegistryResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                applicationInsightsResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                otherResults ?? new ChangeTrackingList<MachineLearningDiagnoseResult>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserDefinedRouteResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  userDefinedRouteResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(UserDefinedRouteResults))
                {
                    if (UserDefinedRouteResults.Any())
                    {
                        builder.Append("  userDefinedRouteResults: ");
                        builder.AppendLine("[");
                        foreach (var item in UserDefinedRouteResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  userDefinedRouteResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkSecurityRuleResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkSecurityRuleResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NetworkSecurityRuleResults))
                {
                    if (NetworkSecurityRuleResults.Any())
                    {
                        builder.Append("  networkSecurityRuleResults: ");
                        builder.AppendLine("[");
                        foreach (var item in NetworkSecurityRuleResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  networkSecurityRuleResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceLockResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  resourceLockResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ResourceLockResults))
                {
                    if (ResourceLockResults.Any())
                    {
                        builder.Append("  resourceLockResults: ");
                        builder.AppendLine("[");
                        foreach (var item in ResourceLockResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  resourceLockResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DnsResolutionResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dnsResolutionResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DnsResolutionResults))
                {
                    if (DnsResolutionResults.Any())
                    {
                        builder.Append("  dnsResolutionResults: ");
                        builder.AppendLine("[");
                        foreach (var item in DnsResolutionResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dnsResolutionResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageAccountResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storageAccountResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(StorageAccountResults))
                {
                    if (StorageAccountResults.Any())
                    {
                        builder.Append("  storageAccountResults: ");
                        builder.AppendLine("[");
                        foreach (var item in StorageAccountResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  storageAccountResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KeyVaultResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  keyVaultResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(KeyVaultResults))
                {
                    if (KeyVaultResults.Any())
                    {
                        builder.Append("  keyVaultResults: ");
                        builder.AppendLine("[");
                        foreach (var item in KeyVaultResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  keyVaultResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContainerRegistryResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  containerRegistryResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ContainerRegistryResults))
                {
                    if (ContainerRegistryResults.Any())
                    {
                        builder.Append("  containerRegistryResults: ");
                        builder.AppendLine("[");
                        foreach (var item in ContainerRegistryResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  containerRegistryResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApplicationInsightsResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  applicationInsightsResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ApplicationInsightsResults))
                {
                    if (ApplicationInsightsResults.Any())
                    {
                        builder.Append("  applicationInsightsResults: ");
                        builder.AppendLine("[");
                        foreach (var item in ApplicationInsightsResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  applicationInsightsResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OtherResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  otherResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(OtherResults))
                {
                    if (OtherResults.Any())
                    {
                        builder.Append("  otherResults: ");
                        builder.AppendLine("[");
                        foreach (var item in OtherResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  otherResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MachineLearningDiagnoseResultValue>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDiagnoseResultValue>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningDiagnoseResultValue)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningDiagnoseResultValue IPersistableModel<MachineLearningDiagnoseResultValue>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDiagnoseResultValue>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningDiagnoseResultValue(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningDiagnoseResultValue)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningDiagnoseResultValue>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
