// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningDeploymentLogsContent : IUtf8JsonSerializable, IJsonModel<MachineLearningDeploymentLogsContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningDeploymentLogsContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningDeploymentLogsContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDeploymentLogsContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningDeploymentLogsContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ContainerType))
            {
                writer.WritePropertyName("containerType"u8);
                writer.WriteStringValue(ContainerType.Value.ToString());
            }
            if (Optional.IsDefined(Tail))
            {
                if (Tail != null)
                {
                    writer.WritePropertyName("tail"u8);
                    writer.WriteNumberValue(Tail.Value);
                }
                else
                {
                    writer.WriteNull("tail");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningDeploymentLogsContent IJsonModel<MachineLearningDeploymentLogsContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDeploymentLogsContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningDeploymentLogsContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningDeploymentLogsContent(document.RootElement, options);
        }

        internal static MachineLearningDeploymentLogsContent DeserializeMachineLearningDeploymentLogsContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MachineLearningContainerType? containerType = default;
            int? tail = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("containerType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    containerType = new MachineLearningContainerType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tail"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        tail = null;
                        continue;
                    }
                    tail = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningDeploymentLogsContent(containerType, tail, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MachineLearningDeploymentLogsContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDeploymentLogsContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningDeploymentLogsContent)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningDeploymentLogsContent IPersistableModel<MachineLearningDeploymentLogsContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningDeploymentLogsContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningDeploymentLogsContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningDeploymentLogsContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningDeploymentLogsContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
