// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Properties of Databricks. </summary>
    public partial class MachineLearningDatabricksProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningDatabricksProperties"/>. </summary>
        public MachineLearningDatabricksProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningDatabricksProperties"/>. </summary>
        /// <param name="databricksAccessToken"> Databricks access token. </param>
        /// <param name="workspaceUri"> Workspace Url. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningDatabricksProperties(string databricksAccessToken, Uri workspaceUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DatabricksAccessToken = databricksAccessToken;
            WorkspaceUri = workspaceUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Databricks access token. </summary>
        [WirePath("databricksAccessToken")]
        public string DatabricksAccessToken { get; set; }
        /// <summary> Workspace Url. </summary>
        [WirePath("workspaceUrl")]
        public Uri WorkspaceUri { get; set; }
    }
}
