// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the type of data. </summary>
    public readonly partial struct MachineLearningDataType : IEquatable<MachineLearningDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UriFileValue = "uri_file";
        private const string UriFolderValue = "uri_folder";
        private const string MltableValue = "mltable";

        /// <summary> uri_file. </summary>
        public static MachineLearningDataType UriFile { get; } = new MachineLearningDataType(UriFileValue);
        /// <summary> uri_folder. </summary>
        public static MachineLearningDataType UriFolder { get; } = new MachineLearningDataType(UriFolderValue);
        /// <summary> mltable. </summary>
        public static MachineLearningDataType Mltable { get; } = new MachineLearningDataType(MltableValue);
        /// <summary> Determines if two <see cref="MachineLearningDataType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningDataType left, MachineLearningDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningDataType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningDataType left, MachineLearningDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningDataType"/>. </summary>
        public static implicit operator MachineLearningDataType(string value) => new MachineLearningDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
