// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningContainerType. </summary>
    public readonly partial struct MachineLearningContainerType : IEquatable<MachineLearningContainerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningContainerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningContainerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StorageInitializerValue = "StorageInitializer";
        private const string InferenceServerValue = "InferenceServer";

        /// <summary> StorageInitializer. </summary>
        public static MachineLearningContainerType StorageInitializer { get; } = new MachineLearningContainerType(StorageInitializerValue);
        /// <summary> InferenceServer. </summary>
        public static MachineLearningContainerType InferenceServer { get; } = new MachineLearningContainerType(InferenceServerValue);
        /// <summary> Determines if two <see cref="MachineLearningContainerType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningContainerType left, MachineLearningContainerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningContainerType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningContainerType left, MachineLearningContainerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningContainerType"/>. </summary>
        public static implicit operator MachineLearningContainerType(string value) => new MachineLearningContainerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningContainerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningContainerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
