// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningContainerResourceSettings. </summary>
    public partial class MachineLearningContainerResourceSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningContainerResourceSettings"/>. </summary>
        public MachineLearningContainerResourceSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningContainerResourceSettings"/>. </summary>
        /// <param name="cpu">
        /// Number of vCPUs request/limit for container. More info:
        /// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        /// </param>
        /// <param name="memory">
        /// Memory size request/limit for container. More info:
        /// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        /// </param>
        /// <param name="gpu">
        /// Number of Nvidia GPU cards request/limit for container. More info:
        /// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningContainerResourceSettings(string cpu, string memory, string gpu, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cpu = cpu;
            Memory = memory;
            Gpu = gpu;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Number of vCPUs request/limit for container. More info:
        /// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        /// </summary>
        [WirePath("cpu")]
        public string Cpu { get; set; }
        /// <summary>
        /// Memory size request/limit for container. More info:
        /// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        /// </summary>
        [WirePath("memory")]
        public string Memory { get; set; }
        /// <summary>
        /// Number of Nvidia GPU cards request/limit for container. More info:
        /// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        /// </summary>
        [WirePath("gpu")]
        public string Gpu { get; set; }
    }
}
