// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Resource requirements for each container instance within an online deployment. </summary>
    public partial class MachineLearningContainerResourceRequirements
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningContainerResourceRequirements"/>. </summary>
        public MachineLearningContainerResourceRequirements()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningContainerResourceRequirements"/>. </summary>
        /// <param name="containerResourceRequests"> Container resource request info:. </param>
        /// <param name="containerResourceLimits"> Container resource limit info:. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningContainerResourceRequirements(MachineLearningContainerResourceSettings containerResourceRequests, MachineLearningContainerResourceSettings containerResourceLimits, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContainerResourceRequests = containerResourceRequests;
            ContainerResourceLimits = containerResourceLimits;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Container resource request info:. </summary>
        [WirePath("containerResourceRequests")]
        public MachineLearningContainerResourceSettings ContainerResourceRequests { get; set; }
        /// <summary> Container resource limit info:. </summary>
        [WirePath("containerResourceLimits")]
        public MachineLearningContainerResourceSettings ContainerResourceLimits { get; set; }
    }
}
