// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> A system service running on a compute. </summary>
    public partial class MachineLearningComputeSystemService
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeSystemService"/>. </summary>
        internal MachineLearningComputeSystemService()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeSystemService"/>. </summary>
        /// <param name="systemServiceType"> The type of this system service. </param>
        /// <param name="publicIPAddress"> Public IP address. </param>
        /// <param name="version"> The version for this type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningComputeSystemService(string systemServiceType, string publicIPAddress, string version, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SystemServiceType = systemServiceType;
            PublicIPAddress = publicIPAddress;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of this system service. </summary>
        [WirePath("systemServiceType")]
        public string SystemServiceType { get; }
        /// <summary> Public IP address. </summary>
        [WirePath("publicIpAddress")]
        public string PublicIPAddress { get; }
        /// <summary> The version for this type. </summary>
        [WirePath("version")]
        public string Version { get; }
    }
}
