// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Compute start stop schedule properties. </summary>
    public partial class MachineLearningComputeStartStopSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeStartStopSchedule"/>. </summary>
        public MachineLearningComputeStartStopSchedule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeStartStopSchedule"/>. </summary>
        /// <param name="id"> A system assigned id for the schedule. </param>
        /// <param name="provisioningStatus"> The current deployment state of schedule. </param>
        /// <param name="status"> Is the schedule enabled or disabled?. </param>
        /// <param name="action"> [Required] The compute power action. </param>
        /// <param name="triggerType"> [Required] The schedule trigger type. </param>
        /// <param name="recurrenceSchedule"> Required if triggerType is Recurrence. </param>
        /// <param name="cronSchedule"> Required if triggerType is Cron. </param>
        /// <param name="schedule"> [Deprecated] Not used any more. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningComputeStartStopSchedule(string id, MachineLearningComputeProvisioningStatus? provisioningStatus, MachineLearningScheduleStatus? status, MachineLearningComputePowerAction? action, MachineLearningTriggerType? triggerType, ComputeStartStopRecurrenceSchedule recurrenceSchedule, ComputeStartStopCronSchedule cronSchedule, MachineLearningScheduleBase schedule, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            ProvisioningStatus = provisioningStatus;
            Status = status;
            Action = action;
            TriggerType = triggerType;
            RecurrenceSchedule = recurrenceSchedule;
            CronSchedule = cronSchedule;
            Schedule = schedule;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A system assigned id for the schedule. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> The current deployment state of schedule. </summary>
        [WirePath("provisioningStatus")]
        public MachineLearningComputeProvisioningStatus? ProvisioningStatus { get; }
        /// <summary> Is the schedule enabled or disabled?. </summary>
        [WirePath("status")]
        public MachineLearningScheduleStatus? Status { get; set; }
        /// <summary> [Required] The compute power action. </summary>
        [WirePath("action")]
        public MachineLearningComputePowerAction? Action { get; set; }
        /// <summary> [Required] The schedule trigger type. </summary>
        [WirePath("triggerType")]
        public MachineLearningTriggerType? TriggerType { get; set; }
        /// <summary> Required if triggerType is Recurrence. </summary>
        [WirePath("recurrence")]
        public ComputeStartStopRecurrenceSchedule RecurrenceSchedule { get; set; }
        /// <summary> Required if triggerType is Cron. </summary>
        [WirePath("cron")]
        public ComputeStartStopCronSchedule CronSchedule { get; set; }
        /// <summary> [Deprecated] Not used any more. </summary>
        [WirePath("schedule")]
        public MachineLearningScheduleBase Schedule { get; set; }
    }
}
