// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to describe the frequency of a compute recurrence schedule. </summary>
    public readonly partial struct MachineLearningComputeRecurrenceFrequency : IEquatable<MachineLearningComputeRecurrenceFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeRecurrenceFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningComputeRecurrenceFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MinuteValue = "Minute";
        private const string HourValue = "Hour";
        private const string DayValue = "Day";
        private const string WeekValue = "Week";
        private const string MonthValue = "Month";

        /// <summary> Minute frequency. </summary>
        public static MachineLearningComputeRecurrenceFrequency Minute { get; } = new MachineLearningComputeRecurrenceFrequency(MinuteValue);
        /// <summary> Hour frequency. </summary>
        public static MachineLearningComputeRecurrenceFrequency Hour { get; } = new MachineLearningComputeRecurrenceFrequency(HourValue);
        /// <summary> Day frequency. </summary>
        public static MachineLearningComputeRecurrenceFrequency Day { get; } = new MachineLearningComputeRecurrenceFrequency(DayValue);
        /// <summary> Week frequency. </summary>
        public static MachineLearningComputeRecurrenceFrequency Week { get; } = new MachineLearningComputeRecurrenceFrequency(WeekValue);
        /// <summary> Month frequency. </summary>
        public static MachineLearningComputeRecurrenceFrequency Month { get; } = new MachineLearningComputeRecurrenceFrequency(MonthValue);
        /// <summary> Determines if two <see cref="MachineLearningComputeRecurrenceFrequency"/> values are the same. </summary>
        public static bool operator ==(MachineLearningComputeRecurrenceFrequency left, MachineLearningComputeRecurrenceFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningComputeRecurrenceFrequency"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningComputeRecurrenceFrequency left, MachineLearningComputeRecurrenceFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningComputeRecurrenceFrequency"/>. </summary>
        public static implicit operator MachineLearningComputeRecurrenceFrequency(string value) => new MachineLearningComputeRecurrenceFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningComputeRecurrenceFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningComputeRecurrenceFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
