// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The compute power action. </summary>
    public readonly partial struct MachineLearningComputePowerAction : IEquatable<MachineLearningComputePowerAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputePowerAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningComputePowerAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StartValue = "Start";
        private const string StopValue = "Stop";

        /// <summary> Start. </summary>
        public static MachineLearningComputePowerAction Start { get; } = new MachineLearningComputePowerAction(StartValue);
        /// <summary> Stop. </summary>
        public static MachineLearningComputePowerAction Stop { get; } = new MachineLearningComputePowerAction(StopValue);
        /// <summary> Determines if two <see cref="MachineLearningComputePowerAction"/> values are the same. </summary>
        public static bool operator ==(MachineLearningComputePowerAction left, MachineLearningComputePowerAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningComputePowerAction"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningComputePowerAction left, MachineLearningComputePowerAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningComputePowerAction"/>. </summary>
        public static implicit operator MachineLearningComputePowerAction(string value) => new MachineLearningComputePowerAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningComputePowerAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningComputePowerAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
