// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningComputeInstanceProperties : IUtf8JsonSerializable, IJsonModel<MachineLearningComputeInstanceProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningComputeInstanceProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningComputeInstanceProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningComputeInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningComputeInstanceProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(VmSize))
            {
                writer.WritePropertyName("vmSize"u8);
                writer.WriteStringValue(VmSize);
            }
            if (Optional.IsDefined(Subnet))
            {
                if (Subnet != null)
                {
                    writer.WritePropertyName("subnet"u8);
                    writer.WriteObjectValue(Subnet, options);
                }
                else
                {
                    writer.WriteNull("subnet");
                }
            }
            if (Optional.IsDefined(ApplicationSharingPolicy))
            {
                writer.WritePropertyName("applicationSharingPolicy"u8);
                writer.WriteStringValue(ApplicationSharingPolicy.Value.ToString());
            }
            if (Optional.IsDefined(SshSettings))
            {
                if (SshSettings != null)
                {
                    writer.WritePropertyName("sshSettings"u8);
                    writer.WriteObjectValue(SshSettings, options);
                }
                else
                {
                    writer.WriteNull("sshSettings");
                }
            }
            if (Optional.IsCollectionDefined(CustomServices))
            {
                if (CustomServices != null)
                {
                    writer.WritePropertyName("customServices"u8);
                    writer.WriteStartArray();
                    foreach (var item in CustomServices)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("customServices");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(OSImageMetadata))
            {
                writer.WritePropertyName("osImageMetadata"u8);
                writer.WriteObjectValue(OSImageMetadata, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectivityEndpoints))
            {
                writer.WritePropertyName("connectivityEndpoints"u8);
                writer.WriteObjectValue(ConnectivityEndpoints, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Applications))
            {
                writer.WritePropertyName("applications"u8);
                writer.WriteStartArray();
                foreach (var item in Applications)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedBy))
            {
                writer.WritePropertyName("createdBy"u8);
                writer.WriteObjectValue(CreatedBy, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteStartArray();
                foreach (var item in Errors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(ComputeInstanceAuthorizationType))
            {
                if (ComputeInstanceAuthorizationType != null)
                {
                    writer.WritePropertyName("computeInstanceAuthorizationType"u8);
                    writer.WriteStringValue(ComputeInstanceAuthorizationType.Value.ToString());
                }
                else
                {
                    writer.WriteNull("computeInstanceAuthorizationType");
                }
            }
            if (Optional.IsDefined(PersonalComputeInstanceSettings))
            {
                if (PersonalComputeInstanceSettings != null)
                {
                    writer.WritePropertyName("personalComputeInstanceSettings"u8);
                    writer.WriteObjectValue(PersonalComputeInstanceSettings, options);
                }
                else
                {
                    writer.WriteNull("personalComputeInstanceSettings");
                }
            }
            if (Optional.IsDefined(SetupScriptsSettings))
            {
                if (SetupScriptsSettings != null)
                {
                    writer.WritePropertyName("setupScripts"u8);
                    writer.WriteObjectValue(SetupScriptsSettings, options);
                }
                else
                {
                    writer.WriteNull("setupScripts");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(LastOperation))
            {
                if (LastOperation != null)
                {
                    writer.WritePropertyName("lastOperation"u8);
                    writer.WriteObjectValue(LastOperation, options);
                }
                else
                {
                    writer.WriteNull("lastOperation");
                }
            }
            if (Optional.IsDefined(Schedules))
            {
                if (Schedules != null)
                {
                    writer.WritePropertyName("schedules"u8);
                    writer.WriteObjectValue(Schedules, options);
                }
                else
                {
                    writer.WriteNull("schedules");
                }
            }
            if (Optional.IsDefined(EnableNodePublicIP))
            {
                writer.WritePropertyName("enableNodePublicIp"u8);
                writer.WriteBooleanValue(EnableNodePublicIP.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Containers))
            {
                if (Containers != null)
                {
                    writer.WritePropertyName("containers"u8);
                    writer.WriteStartArray();
                    foreach (var item in Containers)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("containers");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DataDisks))
            {
                if (DataDisks != null)
                {
                    writer.WritePropertyName("dataDisks"u8);
                    writer.WriteStartArray();
                    foreach (var item in DataDisks)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("dataDisks");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DataMounts))
            {
                if (DataMounts != null)
                {
                    writer.WritePropertyName("dataMounts"u8);
                    writer.WriteStartArray();
                    foreach (var item in DataMounts)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("dataMounts");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(Versions))
            {
                writer.WritePropertyName("versions"u8);
                writer.WriteObjectValue(Versions, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningComputeInstanceProperties IJsonModel<MachineLearningComputeInstanceProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningComputeInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningComputeInstanceProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningComputeInstanceProperties(document.RootElement, options);
        }

        internal static MachineLearningComputeInstanceProperties DeserializeMachineLearningComputeInstanceProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string vmSize = default;
            ResourceId subnet = default;
            MachineLearningApplicationSharingPolicy? applicationSharingPolicy = default;
            MachineLearningComputeInstanceSshSettings sshSettings = default;
            IList<CustomService> customServices = default;
            ImageMetadata osImageMetadata = default;
            MachineLearningComputeInstanceConnectivityEndpoints connectivityEndpoints = default;
            IReadOnlyList<MachineLearningComputeInstanceApplication> applications = default;
            MachineLearningComputeInstanceCreatedBy createdBy = default;
            IReadOnlyList<MachineLearningError> errors = default;
            MachineLearningComputeInstanceState? state = default;
            MachineLearningComputeInstanceAuthorizationType? computeInstanceAuthorizationType = default;
            PersonalComputeInstanceSettings personalComputeInstanceSettings = default;
            SetupScripts setupScripts = default;
            MachineLearningComputeInstanceLastOperation lastOperation = default;
            ComputeSchedules schedules = default;
            bool? enableNodePublicIP = default;
            IReadOnlyList<MachineLearningComputeInstanceContainer> containers = default;
            IReadOnlyList<MachineLearningComputeInstanceDataDisk> dataDisks = default;
            IReadOnlyList<MachineLearningComputeInstanceDataMount> dataMounts = default;
            ComputeInstanceVersion versions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("vmSize"u8))
                {
                    vmSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subnet"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        subnet = null;
                        continue;
                    }
                    subnet = ResourceId.DeserializeResourceId(property.Value, options);
                    continue;
                }
                if (property.NameEquals("applicationSharingPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    applicationSharingPolicy = new MachineLearningApplicationSharingPolicy(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sshSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        sshSettings = null;
                        continue;
                    }
                    sshSettings = MachineLearningComputeInstanceSshSettings.DeserializeMachineLearningComputeInstanceSshSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("customServices"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        customServices = null;
                        continue;
                    }
                    List<CustomService> array = new List<CustomService>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CustomService.DeserializeCustomService(item, options));
                    }
                    customServices = array;
                    continue;
                }
                if (property.NameEquals("osImageMetadata"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    osImageMetadata = ImageMetadata.DeserializeImageMetadata(property.Value, options);
                    continue;
                }
                if (property.NameEquals("connectivityEndpoints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectivityEndpoints = MachineLearningComputeInstanceConnectivityEndpoints.DeserializeMachineLearningComputeInstanceConnectivityEndpoints(property.Value, options);
                    continue;
                }
                if (property.NameEquals("applications"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningComputeInstanceApplication> array = new List<MachineLearningComputeInstanceApplication>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningComputeInstanceApplication.DeserializeMachineLearningComputeInstanceApplication(item, options));
                    }
                    applications = array;
                    continue;
                }
                if (property.NameEquals("createdBy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    createdBy = MachineLearningComputeInstanceCreatedBy.DeserializeMachineLearningComputeInstanceCreatedBy(property.Value, options);
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MachineLearningError> array = new List<MachineLearningError>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningError.DeserializeMachineLearningError(item, options));
                    }
                    errors = array;
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new MachineLearningComputeInstanceState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("computeInstanceAuthorizationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        computeInstanceAuthorizationType = null;
                        continue;
                    }
                    computeInstanceAuthorizationType = new MachineLearningComputeInstanceAuthorizationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("personalComputeInstanceSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        personalComputeInstanceSettings = null;
                        continue;
                    }
                    personalComputeInstanceSettings = PersonalComputeInstanceSettings.DeserializePersonalComputeInstanceSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("setupScripts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        setupScripts = null;
                        continue;
                    }
                    setupScripts = SetupScripts.DeserializeSetupScripts(property.Value, options);
                    continue;
                }
                if (property.NameEquals("lastOperation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        lastOperation = null;
                        continue;
                    }
                    lastOperation = MachineLearningComputeInstanceLastOperation.DeserializeMachineLearningComputeInstanceLastOperation(property.Value, options);
                    continue;
                }
                if (property.NameEquals("schedules"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        schedules = null;
                        continue;
                    }
                    schedules = ComputeSchedules.DeserializeComputeSchedules(property.Value, options);
                    continue;
                }
                if (property.NameEquals("enableNodePublicIp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableNodePublicIP = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("containers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        containers = null;
                        continue;
                    }
                    List<MachineLearningComputeInstanceContainer> array = new List<MachineLearningComputeInstanceContainer>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningComputeInstanceContainer.DeserializeMachineLearningComputeInstanceContainer(item, options));
                    }
                    containers = array;
                    continue;
                }
                if (property.NameEquals("dataDisks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        dataDisks = null;
                        continue;
                    }
                    List<MachineLearningComputeInstanceDataDisk> array = new List<MachineLearningComputeInstanceDataDisk>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningComputeInstanceDataDisk.DeserializeMachineLearningComputeInstanceDataDisk(item, options));
                    }
                    dataDisks = array;
                    continue;
                }
                if (property.NameEquals("dataMounts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        dataMounts = null;
                        continue;
                    }
                    List<MachineLearningComputeInstanceDataMount> array = new List<MachineLearningComputeInstanceDataMount>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningComputeInstanceDataMount.DeserializeMachineLearningComputeInstanceDataMount(item, options));
                    }
                    dataMounts = array;
                    continue;
                }
                if (property.NameEquals("versions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    versions = ComputeInstanceVersion.DeserializeComputeInstanceVersion(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningComputeInstanceProperties(
                vmSize,
                subnet,
                applicationSharingPolicy,
                sshSettings,
                customServices ?? new ChangeTrackingList<CustomService>(),
                osImageMetadata,
                connectivityEndpoints,
                applications ?? new ChangeTrackingList<MachineLearningComputeInstanceApplication>(),
                createdBy,
                errors ?? new ChangeTrackingList<MachineLearningError>(),
                state,
                computeInstanceAuthorizationType,
                personalComputeInstanceSettings,
                setupScripts,
                lastOperation,
                schedules,
                enableNodePublicIP,
                containers ?? new ChangeTrackingList<MachineLearningComputeInstanceContainer>(),
                dataDisks ?? new ChangeTrackingList<MachineLearningComputeInstanceDataDisk>(),
                dataMounts ?? new ChangeTrackingList<MachineLearningComputeInstanceDataMount>(),
                versions,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VmSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  vmSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VmSize))
                {
                    builder.Append("  vmSize: ");
                    if (VmSize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{VmSize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{VmSize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("SubnetId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  subnet: ");
                builder.AppendLine("{");
                builder.Append("    id: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Subnet))
                {
                    builder.Append("  subnet: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Subnet, options, 2, false, "  subnet: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApplicationSharingPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  applicationSharingPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApplicationSharingPolicy))
                {
                    builder.Append("  applicationSharingPolicy: ");
                    builder.AppendLine($"'{ApplicationSharingPolicy.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SshSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sshSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SshSettings))
                {
                    builder.Append("  sshSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SshSettings, options, 2, false, "  sshSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomServices), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customServices: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomServices))
                {
                    if (CustomServices.Any())
                    {
                        builder.Append("  customServices: ");
                        builder.AppendLine("[");
                        foreach (var item in CustomServices)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  customServices: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSImageMetadata), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  osImageMetadata: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSImageMetadata))
                {
                    builder.Append("  osImageMetadata: ");
                    BicepSerializationHelpers.AppendChildObject(builder, OSImageMetadata, options, 2, false, "  osImageMetadata: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectivityEndpoints), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  connectivityEndpoints: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConnectivityEndpoints))
                {
                    builder.Append("  connectivityEndpoints: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ConnectivityEndpoints, options, 2, false, "  connectivityEndpoints: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Applications), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  applications: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Applications))
                {
                    if (Applications.Any())
                    {
                        builder.Append("  applications: ");
                        builder.AppendLine("[");
                        foreach (var item in Applications)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  applications: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedBy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  createdBy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedBy))
                {
                    builder.Append("  createdBy: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CreatedBy, options, 2, false, "  createdBy: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Errors), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  errors: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Errors))
                {
                    if (Errors.Any())
                    {
                        builder.Append("  errors: ");
                        builder.AppendLine("[");
                        foreach (var item in Errors)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  errors: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("  state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ComputeInstanceAuthorizationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  computeInstanceAuthorizationType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ComputeInstanceAuthorizationType))
                {
                    builder.Append("  computeInstanceAuthorizationType: ");
                    builder.AppendLine($"'{ComputeInstanceAuthorizationType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("PersonalComputeInstanceAssignedUser", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  personalComputeInstanceSettings: ");
                builder.AppendLine("{");
                builder.Append("    assignedUser: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(PersonalComputeInstanceSettings))
                {
                    builder.Append("  personalComputeInstanceSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PersonalComputeInstanceSettings, options, 2, false, "  personalComputeInstanceSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("Scripts", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  setupScripts: ");
                builder.AppendLine("{");
                builder.Append("    scripts: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(SetupScriptsSettings))
                {
                    builder.Append("  setupScripts: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SetupScriptsSettings, options, 2, false, "  setupScripts: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastOperation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastOperation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastOperation))
                {
                    builder.Append("  lastOperation: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LastOperation, options, 2, false, "  lastOperation: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("SchedulesComputeStartStop", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  schedules: ");
                builder.AppendLine("{");
                builder.Append("    computeStartStop: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Schedules))
                {
                    builder.Append("  schedules: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Schedules, options, 2, false, "  schedules: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableNodePublicIP), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableNodePublicIp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableNodePublicIP))
                {
                    builder.Append("  enableNodePublicIp: ");
                    var boolValue = EnableNodePublicIP.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Containers), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  containers: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Containers))
                {
                    if (Containers.Any())
                    {
                        builder.Append("  containers: ");
                        builder.AppendLine("[");
                        foreach (var item in Containers)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  containers: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataDisks), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataDisks: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DataDisks))
                {
                    if (DataDisks.Any())
                    {
                        builder.Append("  dataDisks: ");
                        builder.AppendLine("[");
                        foreach (var item in DataDisks)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dataDisks: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataMounts), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataMounts: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DataMounts))
                {
                    if (DataMounts.Any())
                    {
                        builder.Append("  dataMounts: ");
                        builder.AppendLine("[");
                        foreach (var item in DataMounts)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dataMounts: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("VersionsRuntime", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  versions: ");
                builder.AppendLine("{");
                builder.Append("    runtime: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(Versions))
                {
                    builder.Append("  versions: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Versions, options, 2, false, "  versions: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MachineLearningComputeInstanceProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningComputeInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningComputeInstanceProperties)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningComputeInstanceProperties IPersistableModel<MachineLearningComputeInstanceProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningComputeInstanceProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningComputeInstanceProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningComputeInstanceProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningComputeInstanceProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
