// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Describes information on user who created this ComputeInstance. </summary>
    public partial class MachineLearningComputeInstanceCreatedBy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceCreatedBy"/>. </summary>
        internal MachineLearningComputeInstanceCreatedBy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceCreatedBy"/>. </summary>
        /// <param name="userName"> Name of the user. </param>
        /// <param name="userOrgId"> Uniquely identifies user' Azure Active Directory organization. </param>
        /// <param name="userId"> Uniquely identifies the user within his/her organization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningComputeInstanceCreatedBy(string userName, string userOrgId, string userId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserName = userName;
            UserOrgId = userOrgId;
            UserId = userId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the user. </summary>
        [WirePath("userName")]
        public string UserName { get; }
        /// <summary> Uniquely identifies user' Azure Active Directory organization. </summary>
        [WirePath("userOrgId")]
        public string UserOrgId { get; }
        /// <summary> Uniquely identifies the user within his/her organization. </summary>
        [WirePath("userId")]
        public string UserId { get; }
    }
}
