// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Defines an Aml Instance container. </summary>
    public partial class MachineLearningComputeInstanceContainer
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceContainer"/>. </summary>
        internal MachineLearningComputeInstanceContainer()
        {
            Services = new ChangeTrackingList<BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceContainer"/>. </summary>
        /// <param name="name"> Name of the ComputeInstance container. </param>
        /// <param name="autosave"> Auto save settings. </param>
        /// <param name="gpu"> Information of GPU. </param>
        /// <param name="network"> network of this container. </param>
        /// <param name="environment"> Environment information of this container. </param>
        /// <param name="services"> services of this containers. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningComputeInstanceContainer(string name, MachineLearningComputeInstanceAutosave? autosave, string gpu, MachineLearningNetwork? network, MachineLearningComputeInstanceEnvironmentInfo environment, IReadOnlyList<BinaryData> services, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Autosave = autosave;
            Gpu = gpu;
            Network = network;
            Environment = environment;
            Services = services;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the ComputeInstance container. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Auto save settings. </summary>
        [WirePath("autosave")]
        public MachineLearningComputeInstanceAutosave? Autosave { get; }
        /// <summary> Information of GPU. </summary>
        [WirePath("gpu")]
        public string Gpu { get; }
        /// <summary> network of this container. </summary>
        [WirePath("network")]
        public MachineLearningNetwork? Network { get; }
        /// <summary> Environment information of this container. </summary>
        [WirePath("environment")]
        public MachineLearningComputeInstanceEnvironmentInfo Environment { get; }
        /// <summary>
        /// services of this containers.
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("services")]
        public IReadOnlyList<BinaryData> Services { get; }
    }
}
