// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Auto save settings. </summary>
    public readonly partial struct MachineLearningComputeInstanceAutosave : IEquatable<MachineLearningComputeInstanceAutosave>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceAutosave"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningComputeInstanceAutosave(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string LocalValue = "Local";
        private const string RemoteValue = "Remote";

        /// <summary> None. </summary>
        public static MachineLearningComputeInstanceAutosave None { get; } = new MachineLearningComputeInstanceAutosave(NoneValue);
        /// <summary> Local. </summary>
        public static MachineLearningComputeInstanceAutosave Local { get; } = new MachineLearningComputeInstanceAutosave(LocalValue);
        /// <summary> Remote. </summary>
        public static MachineLearningComputeInstanceAutosave Remote { get; } = new MachineLearningComputeInstanceAutosave(RemoteValue);
        /// <summary> Determines if two <see cref="MachineLearningComputeInstanceAutosave"/> values are the same. </summary>
        public static bool operator ==(MachineLearningComputeInstanceAutosave left, MachineLearningComputeInstanceAutosave right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningComputeInstanceAutosave"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningComputeInstanceAutosave left, MachineLearningComputeInstanceAutosave right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningComputeInstanceAutosave"/>. </summary>
        public static implicit operator MachineLearningComputeInstanceAutosave(string value) => new MachineLearningComputeInstanceAutosave(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningComputeInstanceAutosave other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningComputeInstanceAutosave other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
