// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Defines an Aml Instance application and its connectivity endpoint URI. </summary>
    public partial class MachineLearningComputeInstanceApplication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceApplication"/>. </summary>
        internal MachineLearningComputeInstanceApplication()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningComputeInstanceApplication"/>. </summary>
        /// <param name="displayName"> Name of the ComputeInstance application. </param>
        /// <param name="endpointUri"> Application' endpoint URI. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningComputeInstanceApplication(string displayName, Uri endpointUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            EndpointUri = endpointUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the ComputeInstance application. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; }
        /// <summary> Application' endpoint URI. </summary>
        [WirePath("endpointUri")]
        public Uri EndpointUri { get; }
    }
}
