// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Command Job limit class. </summary>
    public partial class MachineLearningCommandJobLimits : MachineLearningJobLimits
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningCommandJobLimits"/>. </summary>
        public MachineLearningCommandJobLimits()
        {
            JobLimitsType = JobLimitsType.Command;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningCommandJobLimits"/>. </summary>
        /// <param name="jobLimitsType"> [Required] JobLimit type. </param>
        /// <param name="timeout"> The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningCommandJobLimits(JobLimitsType jobLimitsType, TimeSpan? timeout, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(jobLimitsType, timeout, serializedAdditionalRawData)
        {
            JobLimitsType = jobLimitsType;
        }
    }
}
