// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Configuration for a scoring code asset. </summary>
    public partial class MachineLearningCodeConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningCodeConfiguration"/>. </summary>
        /// <param name="scoringScript"> [Required] The script to execute on startup. eg. "score.py". </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scoringScript"/> is null. </exception>
        public MachineLearningCodeConfiguration(string scoringScript)
        {
            Argument.AssertNotNull(scoringScript, nameof(scoringScript));

            ScoringScript = scoringScript;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningCodeConfiguration"/>. </summary>
        /// <param name="codeId"> ARM resource ID of the code asset. </param>
        /// <param name="scoringScript"> [Required] The script to execute on startup. eg. "score.py". </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningCodeConfiguration(ResourceIdentifier codeId, string scoringScript, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CodeId = codeId;
            ScoringScript = scoringScript;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningCodeConfiguration"/> for deserialization. </summary>
        internal MachineLearningCodeConfiguration()
        {
        }

        /// <summary> ARM resource ID of the code asset. </summary>
        [WirePath("codeId")]
        public ResourceIdentifier CodeId { get; set; }
        /// <summary> [Required] The script to execute on startup. eg. "score.py". </summary>
        [WirePath("scoringScript")]
        public string ScoringScript { get; set; }
    }
}
