// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Three lettered code specifying the currency of the VM price. Example: USD. </summary>
    public readonly partial struct MachineLearningBillingCurrency : IEquatable<MachineLearningBillingCurrency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningBillingCurrency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningBillingCurrency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UsdValue = "USD";

        /// <summary> USD. </summary>
        public static MachineLearningBillingCurrency Usd { get; } = new MachineLearningBillingCurrency(UsdValue);
        /// <summary> Determines if two <see cref="MachineLearningBillingCurrency"/> values are the same. </summary>
        public static bool operator ==(MachineLearningBillingCurrency left, MachineLearningBillingCurrency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningBillingCurrency"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningBillingCurrency left, MachineLearningBillingCurrency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningBillingCurrency"/>. </summary>
        public static implicit operator MachineLearningBillingCurrency(string value) => new MachineLearningBillingCurrency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningBillingCurrency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningBillingCurrency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
