// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Retry settings for a batch inference operation. </summary>
    public partial class MachineLearningBatchRetrySettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningBatchRetrySettings"/>. </summary>
        public MachineLearningBatchRetrySettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningBatchRetrySettings"/>. </summary>
        /// <param name="maxRetries"> Maximum retry count for a mini-batch. </param>
        /// <param name="timeout"> Invocation timeout for a mini-batch, in ISO 8601 format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningBatchRetrySettings(int? maxRetries, TimeSpan? timeout, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaxRetries = maxRetries;
            Timeout = timeout;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Maximum retry count for a mini-batch. </summary>
        [WirePath("maxRetries")]
        public int? MaxRetries { get; set; }
        /// <summary> Invocation timeout for a mini-batch, in ISO 8601 format. </summary>
        [WirePath("timeout")]
        public TimeSpan? Timeout { get; set; }
    }
}
