// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary>
    /// Log verbosity for batch inferencing.
    /// Increasing verbosity order for logging is : Warning, Info and Debug.
    /// The default value is Info.
    /// </summary>
    public readonly partial struct MachineLearningBatchLoggingLevel : IEquatable<MachineLearningBatchLoggingLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningBatchLoggingLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningBatchLoggingLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InfoValue = "Info";
        private const string WarningValue = "Warning";
        private const string DebugValue = "Debug";

        /// <summary> Info. </summary>
        public static MachineLearningBatchLoggingLevel Info { get; } = new MachineLearningBatchLoggingLevel(InfoValue);
        /// <summary> Warning. </summary>
        public static MachineLearningBatchLoggingLevel Warning { get; } = new MachineLearningBatchLoggingLevel(WarningValue);
        /// <summary> Debug. </summary>
        public static MachineLearningBatchLoggingLevel Debug { get; } = new MachineLearningBatchLoggingLevel(DebugValue);
        /// <summary> Determines if two <see cref="MachineLearningBatchLoggingLevel"/> values are the same. </summary>
        public static bool operator ==(MachineLearningBatchLoggingLevel left, MachineLearningBatchLoggingLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningBatchLoggingLevel"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningBatchLoggingLevel left, MachineLearningBatchLoggingLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningBatchLoggingLevel"/>. </summary>
        public static implicit operator MachineLearningBatchLoggingLevel(string value) => new MachineLearningBatchLoggingLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningBatchLoggingLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningBatchLoggingLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
