// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role. </summary>
    public readonly partial struct MachineLearningApplicationSharingPolicy : IEquatable<MachineLearningApplicationSharingPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningApplicationSharingPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningApplicationSharingPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PersonalValue = "Personal";
        private const string SharedValue = "Shared";

        /// <summary> Personal. </summary>
        public static MachineLearningApplicationSharingPolicy Personal { get; } = new MachineLearningApplicationSharingPolicy(PersonalValue);
        /// <summary> Shared. </summary>
        public static MachineLearningApplicationSharingPolicy Shared { get; } = new MachineLearningApplicationSharingPolicy(SharedValue);
        /// <summary> Determines if two <see cref="MachineLearningApplicationSharingPolicy"/> values are the same. </summary>
        public static bool operator ==(MachineLearningApplicationSharingPolicy left, MachineLearningApplicationSharingPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningApplicationSharingPolicy"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningApplicationSharingPolicy left, MachineLearningApplicationSharingPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningApplicationSharingPolicy"/>. </summary>
        public static implicit operator MachineLearningApplicationSharingPolicy(string value) => new MachineLearningApplicationSharingPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningApplicationSharingPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningApplicationSharingPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
