// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Secrets related to a Machine Learning compute based on AKS. </summary>
    public partial class MachineLearningAksComputeSecrets : MachineLearningComputeSecrets
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningAksComputeSecrets"/>. </summary>
        internal MachineLearningAksComputeSecrets()
        {
            ComputeType = ComputeType.Aks;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningAksComputeSecrets"/>. </summary>
        /// <param name="computeType"> The type of compute. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="userKubeConfig"> Content of kubeconfig file that can be used to connect to the Kubernetes cluster. </param>
        /// <param name="adminKubeConfig"> Content of kubeconfig file that can be used to connect to the Kubernetes cluster. </param>
        /// <param name="imagePullSecretName"> Image registry pull secret. </param>
        internal MachineLearningAksComputeSecrets(ComputeType computeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string userKubeConfig, string adminKubeConfig, string imagePullSecretName) : base(computeType, serializedAdditionalRawData)
        {
            UserKubeConfig = userKubeConfig;
            AdminKubeConfig = adminKubeConfig;
            ImagePullSecretName = imagePullSecretName;
            ComputeType = computeType;
        }

        /// <summary> Content of kubeconfig file that can be used to connect to the Kubernetes cluster. </summary>
        [WirePath("userKubeConfig")]
        public string UserKubeConfig { get; }
        /// <summary> Content of kubeconfig file that can be used to connect to the Kubernetes cluster. </summary>
        [WirePath("adminKubeConfig")]
        public string AdminKubeConfig { get; }
        /// <summary> Image registry pull secret. </summary>
        [WirePath("imagePullSecretName")]
        public string ImagePullSecretName { get; }
    }
}
