// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class MachineLearningAksComputeProperties : IUtf8JsonSerializable, IJsonModel<MachineLearningAksComputeProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MachineLearningAksComputeProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MachineLearningAksComputeProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningAksComputeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningAksComputeProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ClusterFqdn))
            {
                if (ClusterFqdn != null)
                {
                    writer.WritePropertyName("clusterFqdn"u8);
                    writer.WriteStringValue(ClusterFqdn);
                }
                else
                {
                    writer.WriteNull("clusterFqdn");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SystemServices))
            {
                if (SystemServices != null)
                {
                    writer.WritePropertyName("systemServices"u8);
                    writer.WriteStartArray();
                    foreach (var item in SystemServices)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("systemServices");
                }
            }
            if (Optional.IsDefined(AgentCount))
            {
                if (AgentCount != null)
                {
                    writer.WritePropertyName("agentCount"u8);
                    writer.WriteNumberValue(AgentCount.Value);
                }
                else
                {
                    writer.WriteNull("agentCount");
                }
            }
            if (Optional.IsDefined(AgentVmSize))
            {
                if (AgentVmSize != null)
                {
                    writer.WritePropertyName("agentVmSize"u8);
                    writer.WriteStringValue(AgentVmSize);
                }
                else
                {
                    writer.WriteNull("agentVmSize");
                }
            }
            if (Optional.IsDefined(ClusterPurpose))
            {
                writer.WritePropertyName("clusterPurpose"u8);
                writer.WriteStringValue(ClusterPurpose.Value.ToString());
            }
            if (Optional.IsDefined(SslConfiguration))
            {
                if (SslConfiguration != null)
                {
                    writer.WritePropertyName("sslConfiguration"u8);
                    writer.WriteObjectValue(SslConfiguration, options);
                }
                else
                {
                    writer.WriteNull("sslConfiguration");
                }
            }
            if (Optional.IsDefined(AksNetworkingConfiguration))
            {
                if (AksNetworkingConfiguration != null)
                {
                    writer.WritePropertyName("aksNetworkingConfiguration"u8);
                    writer.WriteObjectValue(AksNetworkingConfiguration, options);
                }
                else
                {
                    writer.WriteNull("aksNetworkingConfiguration");
                }
            }
            if (Optional.IsDefined(LoadBalancerType))
            {
                writer.WritePropertyName("loadBalancerType"u8);
                writer.WriteStringValue(LoadBalancerType.Value.ToString());
            }
            if (Optional.IsDefined(LoadBalancerSubnet))
            {
                if (LoadBalancerSubnet != null)
                {
                    writer.WritePropertyName("loadBalancerSubnet"u8);
                    writer.WriteStringValue(LoadBalancerSubnet);
                }
                else
                {
                    writer.WriteNull("loadBalancerSubnet");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MachineLearningAksComputeProperties IJsonModel<MachineLearningAksComputeProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningAksComputeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MachineLearningAksComputeProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMachineLearningAksComputeProperties(document.RootElement, options);
        }

        internal static MachineLearningAksComputeProperties DeserializeMachineLearningAksComputeProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clusterFqdn = default;
            IReadOnlyList<MachineLearningComputeSystemService> systemServices = default;
            int? agentCount = default;
            string agentVmSize = default;
            MachineLearningClusterPurpose? clusterPurpose = default;
            MachineLearningSslConfiguration sslConfiguration = default;
            MachineLearningAksNetworkingConfiguration aksNetworkingConfiguration = default;
            MachineLearningLoadBalancerType? loadBalancerType = default;
            string loadBalancerSubnet = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clusterFqdn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        clusterFqdn = null;
                        continue;
                    }
                    clusterFqdn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("systemServices"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        systemServices = null;
                        continue;
                    }
                    List<MachineLearningComputeSystemService> array = new List<MachineLearningComputeSystemService>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MachineLearningComputeSystemService.DeserializeMachineLearningComputeSystemService(item, options));
                    }
                    systemServices = array;
                    continue;
                }
                if (property.NameEquals("agentCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        agentCount = null;
                        continue;
                    }
                    agentCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("agentVmSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        agentVmSize = null;
                        continue;
                    }
                    agentVmSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clusterPurpose"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clusterPurpose = new MachineLearningClusterPurpose(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sslConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        sslConfiguration = null;
                        continue;
                    }
                    sslConfiguration = MachineLearningSslConfiguration.DeserializeMachineLearningSslConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("aksNetworkingConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        aksNetworkingConfiguration = null;
                        continue;
                    }
                    aksNetworkingConfiguration = MachineLearningAksNetworkingConfiguration.DeserializeMachineLearningAksNetworkingConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("loadBalancerType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    loadBalancerType = new MachineLearningLoadBalancerType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("loadBalancerSubnet"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        loadBalancerSubnet = null;
                        continue;
                    }
                    loadBalancerSubnet = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MachineLearningAksComputeProperties(
                clusterFqdn,
                systemServices ?? new ChangeTrackingList<MachineLearningComputeSystemService>(),
                agentCount,
                agentVmSize,
                clusterPurpose,
                sslConfiguration,
                aksNetworkingConfiguration,
                loadBalancerType,
                loadBalancerSubnet,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterFqdn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterFqdn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterFqdn))
                {
                    builder.Append("  clusterFqdn: ");
                    if (ClusterFqdn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClusterFqdn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClusterFqdn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemServices), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemServices: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SystemServices))
                {
                    if (SystemServices.Any())
                    {
                        builder.Append("  systemServices: ");
                        builder.AppendLine("[");
                        foreach (var item in SystemServices)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  systemServices: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AgentCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  agentCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AgentCount))
                {
                    builder.Append("  agentCount: ");
                    builder.AppendLine($"{AgentCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AgentVmSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  agentVmSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AgentVmSize))
                {
                    builder.Append("  agentVmSize: ");
                    if (AgentVmSize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AgentVmSize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AgentVmSize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterPurpose), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterPurpose: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterPurpose))
                {
                    builder.Append("  clusterPurpose: ");
                    builder.AppendLine($"'{ClusterPurpose.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SslConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sslConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SslConfiguration))
                {
                    builder.Append("  sslConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SslConfiguration, options, 2, false, "  sslConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AksNetworkingConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  aksNetworkingConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AksNetworkingConfiguration))
                {
                    builder.Append("  aksNetworkingConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AksNetworkingConfiguration, options, 2, false, "  aksNetworkingConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LoadBalancerType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  loadBalancerType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LoadBalancerType))
                {
                    builder.Append("  loadBalancerType: ");
                    builder.AppendLine($"'{LoadBalancerType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LoadBalancerSubnet), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  loadBalancerSubnet: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LoadBalancerSubnet))
                {
                    builder.Append("  loadBalancerSubnet: ");
                    if (LoadBalancerSubnet.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LoadBalancerSubnet}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LoadBalancerSubnet}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MachineLearningAksComputeProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningAksComputeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MachineLearningAksComputeProperties)} does not support writing '{options.Format}' format.");
            }
        }

        MachineLearningAksComputeProperties IPersistableModel<MachineLearningAksComputeProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MachineLearningAksComputeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMachineLearningAksComputeProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MachineLearningAksComputeProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MachineLearningAksComputeProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
