// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Datastore account key secrets. </summary>
    public partial class MachineLearningAccountKeyDatastoreSecrets : MachineLearningDatastoreSecrets
    {
        /// <summary> Initializes a new instance of <see cref="MachineLearningAccountKeyDatastoreSecrets"/>. </summary>
        public MachineLearningAccountKeyDatastoreSecrets()
        {
            SecretsType = SecretsType.AccountKey;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningAccountKeyDatastoreSecrets"/>. </summary>
        /// <param name="secretsType"> [Required] Credential type used to authentication with storage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="key"> Storage account key. </param>
        internal MachineLearningAccountKeyDatastoreSecrets(SecretsType secretsType, IDictionary<string, BinaryData> serializedAdditionalRawData, string key) : base(secretsType, serializedAdditionalRawData)
        {
            Key = key;
            SecretsType = secretsType;
        }

        /// <summary> Storage account key. </summary>
        [WirePath("key")]
        public string Key { get; set; }
    }
}
