// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Learning rate scheduler enum. </summary>
    public readonly partial struct LearningRateScheduler : IEquatable<LearningRateScheduler>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LearningRateScheduler"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LearningRateScheduler(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string WarmupCosineValue = "WarmupCosine";
        private const string StepValue = "Step";

        /// <summary> No learning rate scheduler selected. </summary>
        public static LearningRateScheduler None { get; } = new LearningRateScheduler(NoneValue);
        /// <summary> Cosine Annealing With Warmup. </summary>
        public static LearningRateScheduler WarmupCosine { get; } = new LearningRateScheduler(WarmupCosineValue);
        /// <summary> Step learning rate scheduler. </summary>
        public static LearningRateScheduler Step { get; } = new LearningRateScheduler(StepValue);
        /// <summary> Determines if two <see cref="LearningRateScheduler"/> values are the same. </summary>
        public static bool operator ==(LearningRateScheduler left, LearningRateScheduler right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LearningRateScheduler"/> values are not the same. </summary>
        public static bool operator !=(LearningRateScheduler left, LearningRateScheduler right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LearningRateScheduler"/>. </summary>
        public static implicit operator LearningRateScheduler(string value) => new LearningRateScheduler(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LearningRateScheduler other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LearningRateScheduler other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
