// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The LakeHouseArtifact. </summary>
    public partial class LakeHouseArtifact : OneLakeArtifact
    {
        /// <summary> Initializes a new instance of <see cref="LakeHouseArtifact"/>. </summary>
        /// <param name="artifactName"> [Required] OneLake artifact name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactName"/> is null. </exception>
        public LakeHouseArtifact(string artifactName) : base(artifactName)
        {
            Argument.AssertNotNull(artifactName, nameof(artifactName));

            ArtifactType = OneLakeArtifactType.LakeHouse;
        }

        /// <summary> Initializes a new instance of <see cref="LakeHouseArtifact"/>. </summary>
        /// <param name="artifactType"> [Required] OneLake artifact type. </param>
        /// <param name="artifactName"> [Required] OneLake artifact name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LakeHouseArtifact(OneLakeArtifactType artifactType, string artifactName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(artifactType, artifactName, serializedAdditionalRawData)
        {
            ArtifactType = artifactType;
        }

        /// <summary> Initializes a new instance of <see cref="LakeHouseArtifact"/> for deserialization. </summary>
        internal LakeHouseArtifact()
        {
        }
    }
}
