// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the job tier. </summary>
    public readonly partial struct JobTier : IEquatable<JobTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NullValue = "Null";
        private const string SpotValue = "Spot";
        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";

        /// <summary> Null. </summary>
        public static JobTier Null { get; } = new JobTier(NullValue);
        /// <summary> Spot. </summary>
        public static JobTier Spot { get; } = new JobTier(SpotValue);
        /// <summary> Basic. </summary>
        public static JobTier Basic { get; } = new JobTier(BasicValue);
        /// <summary> Standard. </summary>
        public static JobTier Standard { get; } = new JobTier(StandardValue);
        /// <summary> Premium. </summary>
        public static JobTier Premium { get; } = new JobTier(PremiumValue);
        /// <summary> Determines if two <see cref="JobTier"/> values are the same. </summary>
        public static bool operator ==(JobTier left, JobTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobTier"/> values are not the same. </summary>
        public static bool operator !=(JobTier left, JobTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobTier"/>. </summary>
        public static implicit operator JobTier(string value) => new JobTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
