// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the Job Output Type. </summary>
    internal readonly partial struct JobOutputType : IEquatable<JobOutputType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobOutputType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobOutputType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UriFileValue = "uri_file";
        private const string UriFolderValue = "uri_folder";
        private const string MltableValue = "mltable";
        private const string CustomModelValue = "custom_model";
        private const string MlflowModelValue = "mlflow_model";
        private const string TritonModelValue = "triton_model";

        /// <summary> uri_file. </summary>
        public static JobOutputType UriFile { get; } = new JobOutputType(UriFileValue);
        /// <summary> uri_folder. </summary>
        public static JobOutputType UriFolder { get; } = new JobOutputType(UriFolderValue);
        /// <summary> mltable. </summary>
        public static JobOutputType Mltable { get; } = new JobOutputType(MltableValue);
        /// <summary> custom_model. </summary>
        public static JobOutputType CustomModel { get; } = new JobOutputType(CustomModelValue);
        /// <summary> mlflow_model. </summary>
        public static JobOutputType MlflowModel { get; } = new JobOutputType(MlflowModelValue);
        /// <summary> triton_model. </summary>
        public static JobOutputType TritonModel { get; } = new JobOutputType(TritonModelValue);
        /// <summary> Determines if two <see cref="JobOutputType"/> values are the same. </summary>
        public static bool operator ==(JobOutputType left, JobOutputType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobOutputType"/> values are not the same. </summary>
        public static bool operator !=(JobOutputType left, JobOutputType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobOutputType"/>. </summary>
        public static implicit operator JobOutputType(string value) => new JobOutputType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobOutputType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobOutputType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
