// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the Job Input Type. </summary>
    public readonly partial struct JobInputType : IEquatable<JobInputType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobInputType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobInputType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LiteralValue = "literal";
        private const string UriFileValue = "uri_file";
        private const string UriFolderValue = "uri_folder";
        private const string MltableValue = "mltable";
        private const string CustomModelValue = "custom_model";
        private const string MlflowModelValue = "mlflow_model";
        private const string TritonModelValue = "triton_model";

        /// <summary> literal. </summary>
        public static JobInputType Literal { get; } = new JobInputType(LiteralValue);
        /// <summary> uri_file. </summary>
        public static JobInputType UriFile { get; } = new JobInputType(UriFileValue);
        /// <summary> uri_folder. </summary>
        public static JobInputType UriFolder { get; } = new JobInputType(UriFolderValue);
        /// <summary> mltable. </summary>
        public static JobInputType Mltable { get; } = new JobInputType(MltableValue);
        /// <summary> custom_model. </summary>
        public static JobInputType CustomModel { get; } = new JobInputType(CustomModelValue);
        /// <summary> mlflow_model. </summary>
        public static JobInputType MlflowModel { get; } = new JobInputType(MlflowModelValue);
        /// <summary> triton_model. </summary>
        public static JobInputType TritonModel { get; } = new JobInputType(TritonModelValue);
        /// <summary> Determines if two <see cref="JobInputType"/> values are the same. </summary>
        public static bool operator ==(JobInputType left, JobInputType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobInputType"/> values are not the same. </summary>
        public static bool operator !=(JobInputType left, JobInputType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobInputType"/>. </summary>
        public static implicit operator JobInputType(string value) => new JobInputType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobInputType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobInputType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
