// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Isolation mode for the managed network of a machine learning workspace. </summary>
    public readonly partial struct IsolationMode : IEquatable<IsolationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IsolationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IsolationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string AllowInternetOutboundValue = "AllowInternetOutbound";
        private const string AllowOnlyApprovedOutboundValue = "AllowOnlyApprovedOutbound";

        /// <summary> Disabled. </summary>
        public static IsolationMode Disabled { get; } = new IsolationMode(DisabledValue);
        /// <summary> AllowInternetOutbound. </summary>
        public static IsolationMode AllowInternetOutbound { get; } = new IsolationMode(AllowInternetOutboundValue);
        /// <summary> AllowOnlyApprovedOutbound. </summary>
        public static IsolationMode AllowOnlyApprovedOutbound { get; } = new IsolationMode(AllowOnlyApprovedOutboundValue);
        /// <summary> Determines if two <see cref="IsolationMode"/> values are the same. </summary>
        public static bool operator ==(IsolationMode left, IsolationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IsolationMode"/> values are not the same. </summary>
        public static bool operator !=(IsolationMode left, IsolationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IsolationMode"/>. </summary>
        public static implicit operator IsolationMode(string value) => new IsolationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IsolationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IsolationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
