// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images. </summary>
    public readonly partial struct ImageType : IEquatable<ImageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DockerValue = "docker";
        private const string AzureMLValue = "azureml";

        /// <summary> docker. </summary>
        public static ImageType Docker { get; } = new ImageType(DockerValue);
        /// <summary> azureml. </summary>
        public static ImageType AzureML { get; } = new ImageType(AzureMLValue);
        /// <summary> Determines if two <see cref="ImageType"/> values are the same. </summary>
        public static bool operator ==(ImageType left, ImageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImageType"/> values are not the same. </summary>
        public static bool operator !=(ImageType left, ImageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImageType"/>. </summary>
        public static implicit operator ImageType(string value) => new ImageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
