// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Model sweeping and hyperparameter sweeping related settings. </summary>
    public partial class ImageSweepSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ImageSweepSettings"/>. </summary>
        /// <param name="samplingAlgorithm"> [Required] Type of the hyperparameter sampling algorithms. </param>
        public ImageSweepSettings(SamplingAlgorithmType samplingAlgorithm)
        {
            SamplingAlgorithm = samplingAlgorithm;
        }

        /// <summary> Initializes a new instance of <see cref="ImageSweepSettings"/>. </summary>
        /// <param name="samplingAlgorithm"> [Required] Type of the hyperparameter sampling algorithms. </param>
        /// <param name="earlyTermination">
        /// Type of early termination policy.
        /// Please note <see cref="MachineLearningEarlyTerminationPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BanditPolicy"/>, <see cref="MedianStoppingPolicy"/> and <see cref="TruncationSelectionPolicy"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ImageSweepSettings(SamplingAlgorithmType samplingAlgorithm, MachineLearningEarlyTerminationPolicy earlyTermination, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SamplingAlgorithm = samplingAlgorithm;
            EarlyTermination = earlyTermination;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ImageSweepSettings"/> for deserialization. </summary>
        internal ImageSweepSettings()
        {
        }

        /// <summary> [Required] Type of the hyperparameter sampling algorithms. </summary>
        [WirePath("samplingAlgorithm")]
        public SamplingAlgorithmType SamplingAlgorithm { get; set; }
        /// <summary>
        /// Type of early termination policy.
        /// Please note <see cref="MachineLearningEarlyTerminationPolicy"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BanditPolicy"/>, <see cref="MedianStoppingPolicy"/> and <see cref="TruncationSelectionPolicy"/>.
        /// </summary>
        [WirePath("earlyTermination")]
        public MachineLearningEarlyTerminationPolicy EarlyTermination { get; set; }
    }
}
