// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Describes the Image Specifications. </summary>
    public partial class ImageSetting
    {
        /// <summary> Initializes a new instance of <see cref="ImageSetting"/>. </summary>
        public ImageSetting()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="ImageSetting"/>. </summary>
        /// <param name="imageType"> Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images. </param>
        /// <param name="reference"> Image reference. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal ImageSetting(ImageType? imageType, string reference, IDictionary<string, BinaryData> additionalProperties)
        {
            ImageType = imageType;
            Reference = reference;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images. </summary>
        [WirePath("type")]
        public ImageType? ImageType { get; set; }
        /// <summary> Image reference. </summary>
        [WirePath("reference")]
        public string Reference { get; set; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("AdditionalProperties")]
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
