// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class ImageModelSettingsObjectDetection : IUtf8JsonSerializable, IJsonModel<ImageModelSettingsObjectDetection>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ImageModelSettingsObjectDetection>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ImageModelSettingsObjectDetection>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageModelSettingsObjectDetection>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImageModelSettingsObjectDetection)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(BoxDetectionsPerImage))
            {
                if (BoxDetectionsPerImage != null)
                {
                    writer.WritePropertyName("boxDetectionsPerImage"u8);
                    writer.WriteNumberValue(BoxDetectionsPerImage.Value);
                }
                else
                {
                    writer.WriteNull("boxDetectionsPerImage");
                }
            }
            if (Optional.IsDefined(BoxScoreThreshold))
            {
                if (BoxScoreThreshold != null)
                {
                    writer.WritePropertyName("boxScoreThreshold"u8);
                    writer.WriteNumberValue(BoxScoreThreshold.Value);
                }
                else
                {
                    writer.WriteNull("boxScoreThreshold");
                }
            }
            if (Optional.IsDefined(ImageSize))
            {
                if (ImageSize != null)
                {
                    writer.WritePropertyName("imageSize"u8);
                    writer.WriteNumberValue(ImageSize.Value);
                }
                else
                {
                    writer.WriteNull("imageSize");
                }
            }
            if (Optional.IsDefined(MaxSize))
            {
                if (MaxSize != null)
                {
                    writer.WritePropertyName("maxSize"u8);
                    writer.WriteNumberValue(MaxSize.Value);
                }
                else
                {
                    writer.WriteNull("maxSize");
                }
            }
            if (Optional.IsDefined(MinSize))
            {
                if (MinSize != null)
                {
                    writer.WritePropertyName("minSize"u8);
                    writer.WriteNumberValue(MinSize.Value);
                }
                else
                {
                    writer.WriteNull("minSize");
                }
            }
            if (Optional.IsDefined(ModelSize))
            {
                writer.WritePropertyName("modelSize"u8);
                writer.WriteStringValue(ModelSize.Value.ToString());
            }
            if (Optional.IsDefined(MultiScale))
            {
                if (MultiScale != null)
                {
                    writer.WritePropertyName("multiScale"u8);
                    writer.WriteBooleanValue(MultiScale.Value);
                }
                else
                {
                    writer.WriteNull("multiScale");
                }
            }
            if (Optional.IsDefined(NmsIouThreshold))
            {
                if (NmsIouThreshold != null)
                {
                    writer.WritePropertyName("nmsIouThreshold"u8);
                    writer.WriteNumberValue(NmsIouThreshold.Value);
                }
                else
                {
                    writer.WriteNull("nmsIouThreshold");
                }
            }
            if (Optional.IsDefined(TileGridSize))
            {
                if (TileGridSize != null)
                {
                    writer.WritePropertyName("tileGridSize"u8);
                    writer.WriteStringValue(TileGridSize);
                }
                else
                {
                    writer.WriteNull("tileGridSize");
                }
            }
            if (Optional.IsDefined(TileOverlapRatio))
            {
                if (TileOverlapRatio != null)
                {
                    writer.WritePropertyName("tileOverlapRatio"u8);
                    writer.WriteNumberValue(TileOverlapRatio.Value);
                }
                else
                {
                    writer.WriteNull("tileOverlapRatio");
                }
            }
            if (Optional.IsDefined(TilePredictionsNmsThreshold))
            {
                if (TilePredictionsNmsThreshold != null)
                {
                    writer.WritePropertyName("tilePredictionsNmsThreshold"u8);
                    writer.WriteNumberValue(TilePredictionsNmsThreshold.Value);
                }
                else
                {
                    writer.WriteNull("tilePredictionsNmsThreshold");
                }
            }
            if (Optional.IsDefined(ValidationIouThreshold))
            {
                if (ValidationIouThreshold != null)
                {
                    writer.WritePropertyName("validationIouThreshold"u8);
                    writer.WriteNumberValue(ValidationIouThreshold.Value);
                }
                else
                {
                    writer.WriteNull("validationIouThreshold");
                }
            }
            if (Optional.IsDefined(ValidationMetricType))
            {
                writer.WritePropertyName("validationMetricType"u8);
                writer.WriteStringValue(ValidationMetricType.Value.ToString());
            }
        }

        ImageModelSettingsObjectDetection IJsonModel<ImageModelSettingsObjectDetection>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageModelSettingsObjectDetection>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImageModelSettingsObjectDetection)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeImageModelSettingsObjectDetection(document.RootElement, options);
        }

        internal static ImageModelSettingsObjectDetection DeserializeImageModelSettingsObjectDetection(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? boxDetectionsPerImage = default;
            float? boxScoreThreshold = default;
            int? imageSize = default;
            int? maxSize = default;
            int? minSize = default;
            MachineLearningModelSize? modelSize = default;
            bool? multiScale = default;
            float? nmsIouThreshold = default;
            string tileGridSize = default;
            float? tileOverlapRatio = default;
            float? tilePredictionsNmsThreshold = default;
            float? validationIouThreshold = default;
            ValidationMetricType? validationMetricType = default;
            bool? amsGradient = default;
            string advancedSettings = default;
            string augmentations = default;
            float? beta1 = default;
            float? beta2 = default;
            int? checkpointFrequency = default;
            string checkpointRunId = default;
            MachineLearningFlowModelJobInput checkpointModel = default;
            bool? distributed = default;
            bool? earlyStopping = default;
            int? earlyStoppingDelay = default;
            int? earlyStoppingPatience = default;
            int? evaluationFrequency = default;
            bool? enableOnnxNormalization = default;
            int? gradientAccumulationStep = default;
            int? layersToFreeze = default;
            float? learningRate = default;
            LearningRateScheduler? learningRateScheduler = default;
            string modelName = default;
            float? momentum = default;
            bool? nesterov = default;
            int? numberOfEpochs = default;
            int? numberOfWorkers = default;
            StochasticOptimizer? optimizer = default;
            int? randomSeed = default;
            float? stepLRGamma = default;
            int? stepLRStepSize = default;
            int? trainingBatchSize = default;
            int? validationBatchSize = default;
            float? warmupCosineLRCycles = default;
            int? warmupCosineLRWarmupEpochs = default;
            float? weightDecay = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("boxDetectionsPerImage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        boxDetectionsPerImage = null;
                        continue;
                    }
                    boxDetectionsPerImage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("boxScoreThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        boxScoreThreshold = null;
                        continue;
                    }
                    boxScoreThreshold = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("imageSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        imageSize = null;
                        continue;
                    }
                    imageSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxSize = null;
                        continue;
                    }
                    maxSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        minSize = null;
                        continue;
                    }
                    minSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("modelSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    modelSize = new MachineLearningModelSize(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("multiScale"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        multiScale = null;
                        continue;
                    }
                    multiScale = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("nmsIouThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        nmsIouThreshold = null;
                        continue;
                    }
                    nmsIouThreshold = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("tileGridSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        tileGridSize = null;
                        continue;
                    }
                    tileGridSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tileOverlapRatio"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        tileOverlapRatio = null;
                        continue;
                    }
                    tileOverlapRatio = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("tilePredictionsNmsThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        tilePredictionsNmsThreshold = null;
                        continue;
                    }
                    tilePredictionsNmsThreshold = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("validationIouThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        validationIouThreshold = null;
                        continue;
                    }
                    validationIouThreshold = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("validationMetricType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    validationMetricType = new ValidationMetricType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("amsGradient"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        amsGradient = null;
                        continue;
                    }
                    amsGradient = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("advancedSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        advancedSettings = null;
                        continue;
                    }
                    advancedSettings = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("augmentations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        augmentations = null;
                        continue;
                    }
                    augmentations = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("beta1"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        beta1 = null;
                        continue;
                    }
                    beta1 = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("beta2"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        beta2 = null;
                        continue;
                    }
                    beta2 = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("checkpointFrequency"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        checkpointFrequency = null;
                        continue;
                    }
                    checkpointFrequency = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("checkpointRunId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        checkpointRunId = null;
                        continue;
                    }
                    checkpointRunId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("checkpointModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        checkpointModel = null;
                        continue;
                    }
                    checkpointModel = MachineLearningFlowModelJobInput.DeserializeMachineLearningFlowModelJobInput(property.Value, options);
                    continue;
                }
                if (property.NameEquals("distributed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        distributed = null;
                        continue;
                    }
                    distributed = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("earlyStopping"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        earlyStopping = null;
                        continue;
                    }
                    earlyStopping = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("earlyStoppingDelay"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        earlyStoppingDelay = null;
                        continue;
                    }
                    earlyStoppingDelay = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("earlyStoppingPatience"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        earlyStoppingPatience = null;
                        continue;
                    }
                    earlyStoppingPatience = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("evaluationFrequency"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        evaluationFrequency = null;
                        continue;
                    }
                    evaluationFrequency = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("enableOnnxNormalization"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        enableOnnxNormalization = null;
                        continue;
                    }
                    enableOnnxNormalization = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("gradientAccumulationStep"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        gradientAccumulationStep = null;
                        continue;
                    }
                    gradientAccumulationStep = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("layersToFreeze"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        layersToFreeze = null;
                        continue;
                    }
                    layersToFreeze = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("learningRate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        learningRate = null;
                        continue;
                    }
                    learningRate = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("learningRateScheduler"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    learningRateScheduler = new LearningRateScheduler(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("modelName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        modelName = null;
                        continue;
                    }
                    modelName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("momentum"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        momentum = null;
                        continue;
                    }
                    momentum = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("nesterov"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        nesterov = null;
                        continue;
                    }
                    nesterov = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("numberOfEpochs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        numberOfEpochs = null;
                        continue;
                    }
                    numberOfEpochs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("numberOfWorkers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        numberOfWorkers = null;
                        continue;
                    }
                    numberOfWorkers = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("optimizer"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    optimizer = new StochasticOptimizer(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("randomSeed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        randomSeed = null;
                        continue;
                    }
                    randomSeed = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("stepLRGamma"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        stepLRGamma = null;
                        continue;
                    }
                    stepLRGamma = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("stepLRStepSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        stepLRStepSize = null;
                        continue;
                    }
                    stepLRStepSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("trainingBatchSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        trainingBatchSize = null;
                        continue;
                    }
                    trainingBatchSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("validationBatchSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        validationBatchSize = null;
                        continue;
                    }
                    validationBatchSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("warmupCosineLRCycles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        warmupCosineLRCycles = null;
                        continue;
                    }
                    warmupCosineLRCycles = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("warmupCosineLRWarmupEpochs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        warmupCosineLRWarmupEpochs = null;
                        continue;
                    }
                    warmupCosineLRWarmupEpochs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("weightDecay"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        weightDecay = null;
                        continue;
                    }
                    weightDecay = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ImageModelSettingsObjectDetection(
                amsGradient,
                advancedSettings,
                augmentations,
                beta1,
                beta2,
                checkpointFrequency,
                checkpointRunId,
                checkpointModel,
                distributed,
                earlyStopping,
                earlyStoppingDelay,
                earlyStoppingPatience,
                evaluationFrequency,
                enableOnnxNormalization,
                gradientAccumulationStep,
                layersToFreeze,
                learningRate,
                learningRateScheduler,
                modelName,
                momentum,
                nesterov,
                numberOfEpochs,
                numberOfWorkers,
                optimizer,
                randomSeed,
                stepLRGamma,
                stepLRStepSize,
                trainingBatchSize,
                validationBatchSize,
                warmupCosineLRCycles,
                warmupCosineLRWarmupEpochs,
                weightDecay,
                serializedAdditionalRawData,
                boxDetectionsPerImage,
                boxScoreThreshold,
                imageSize,
                maxSize,
                minSize,
                modelSize,
                multiScale,
                nmsIouThreshold,
                tileGridSize,
                tileOverlapRatio,
                tilePredictionsNmsThreshold,
                validationIouThreshold,
                validationMetricType);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BoxDetectionsPerImage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  boxDetectionsPerImage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BoxDetectionsPerImage))
                {
                    builder.Append("  boxDetectionsPerImage: ");
                    builder.AppendLine($"{BoxDetectionsPerImage.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BoxScoreThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  boxScoreThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BoxScoreThreshold))
                {
                    builder.Append("  boxScoreThreshold: ");
                    builder.AppendLine($"'{BoxScoreThreshold.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImageSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  imageSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImageSize))
                {
                    builder.Append("  imageSize: ");
                    builder.AppendLine($"{ImageSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maxSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxSize))
                {
                    builder.Append("  maxSize: ");
                    builder.AppendLine($"{MaxSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  minSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinSize))
                {
                    builder.Append("  minSize: ");
                    builder.AppendLine($"{MinSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModelSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modelSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModelSize))
                {
                    builder.Append("  modelSize: ");
                    builder.AppendLine($"'{ModelSize.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MultiScale), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  multiScale: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MultiScale))
                {
                    builder.Append("  multiScale: ");
                    var boolValue = MultiScale.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NmsIouThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nmsIouThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NmsIouThreshold))
                {
                    builder.Append("  nmsIouThreshold: ");
                    builder.AppendLine($"'{NmsIouThreshold.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TileGridSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tileGridSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TileGridSize))
                {
                    builder.Append("  tileGridSize: ");
                    if (TileGridSize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TileGridSize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TileGridSize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TileOverlapRatio), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tileOverlapRatio: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TileOverlapRatio))
                {
                    builder.Append("  tileOverlapRatio: ");
                    builder.AppendLine($"'{TileOverlapRatio.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TilePredictionsNmsThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tilePredictionsNmsThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TilePredictionsNmsThreshold))
                {
                    builder.Append("  tilePredictionsNmsThreshold: ");
                    builder.AppendLine($"'{TilePredictionsNmsThreshold.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationIouThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationIouThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationIouThreshold))
                {
                    builder.Append("  validationIouThreshold: ");
                    builder.AppendLine($"'{ValidationIouThreshold.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationMetricType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationMetricType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationMetricType))
                {
                    builder.Append("  validationMetricType: ");
                    builder.AppendLine($"'{ValidationMetricType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmsGradient), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amsGradient: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmsGradient))
                {
                    builder.Append("  amsGradient: ");
                    var boolValue = AmsGradient.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdvancedSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  advancedSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdvancedSettings))
                {
                    builder.Append("  advancedSettings: ");
                    if (AdvancedSettings.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AdvancedSettings}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AdvancedSettings}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Augmentations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  augmentations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Augmentations))
                {
                    builder.Append("  augmentations: ");
                    if (Augmentations.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Augmentations}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Augmentations}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Beta1), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  beta1: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Beta1))
                {
                    builder.Append("  beta1: ");
                    builder.AppendLine($"'{Beta1.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Beta2), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  beta2: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Beta2))
                {
                    builder.Append("  beta2: ");
                    builder.AppendLine($"'{Beta2.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CheckpointFrequency), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  checkpointFrequency: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CheckpointFrequency))
                {
                    builder.Append("  checkpointFrequency: ");
                    builder.AppendLine($"{CheckpointFrequency.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CheckpointRunId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  checkpointRunId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CheckpointRunId))
                {
                    builder.Append("  checkpointRunId: ");
                    if (CheckpointRunId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CheckpointRunId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CheckpointRunId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CheckpointModel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  checkpointModel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CheckpointModel))
                {
                    builder.Append("  checkpointModel: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CheckpointModel, options, 2, false, "  checkpointModel: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Distributed), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  distributed: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Distributed))
                {
                    builder.Append("  distributed: ");
                    var boolValue = Distributed.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EarlyStopping), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  earlyStopping: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EarlyStopping))
                {
                    builder.Append("  earlyStopping: ");
                    var boolValue = EarlyStopping.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EarlyStoppingDelay), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  earlyStoppingDelay: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EarlyStoppingDelay))
                {
                    builder.Append("  earlyStoppingDelay: ");
                    builder.AppendLine($"{EarlyStoppingDelay.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EarlyStoppingPatience), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  earlyStoppingPatience: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EarlyStoppingPatience))
                {
                    builder.Append("  earlyStoppingPatience: ");
                    builder.AppendLine($"{EarlyStoppingPatience.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EvaluationFrequency), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  evaluationFrequency: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EvaluationFrequency))
                {
                    builder.Append("  evaluationFrequency: ");
                    builder.AppendLine($"{EvaluationFrequency.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableOnnxNormalization), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableOnnxNormalization: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableOnnxNormalization))
                {
                    builder.Append("  enableOnnxNormalization: ");
                    var boolValue = EnableOnnxNormalization.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GradientAccumulationStep), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  gradientAccumulationStep: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GradientAccumulationStep))
                {
                    builder.Append("  gradientAccumulationStep: ");
                    builder.AppendLine($"{GradientAccumulationStep.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LayersToFreeze), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  layersToFreeze: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LayersToFreeze))
                {
                    builder.Append("  layersToFreeze: ");
                    builder.AppendLine($"{LayersToFreeze.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LearningRate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  learningRate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LearningRate))
                {
                    builder.Append("  learningRate: ");
                    builder.AppendLine($"'{LearningRate.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LearningRateScheduler), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  learningRateScheduler: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LearningRateScheduler))
                {
                    builder.Append("  learningRateScheduler: ");
                    builder.AppendLine($"'{LearningRateScheduler.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ModelName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modelName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ModelName))
                {
                    builder.Append("  modelName: ");
                    if (ModelName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ModelName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ModelName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Momentum), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  momentum: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Momentum))
                {
                    builder.Append("  momentum: ");
                    builder.AppendLine($"'{Momentum.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Nesterov), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nesterov: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Nesterov))
                {
                    builder.Append("  nesterov: ");
                    var boolValue = Nesterov.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfEpochs), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  numberOfEpochs: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfEpochs))
                {
                    builder.Append("  numberOfEpochs: ");
                    builder.AppendLine($"{NumberOfEpochs.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfWorkers), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  numberOfWorkers: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfWorkers))
                {
                    builder.Append("  numberOfWorkers: ");
                    builder.AppendLine($"{NumberOfWorkers.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Optimizer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  optimizer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Optimizer))
                {
                    builder.Append("  optimizer: ");
                    builder.AppendLine($"'{Optimizer.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RandomSeed), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  randomSeed: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RandomSeed))
                {
                    builder.Append("  randomSeed: ");
                    builder.AppendLine($"{RandomSeed.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StepLRGamma), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stepLRGamma: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StepLRGamma))
                {
                    builder.Append("  stepLRGamma: ");
                    builder.AppendLine($"'{StepLRGamma.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StepLRStepSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stepLRStepSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StepLRStepSize))
                {
                    builder.Append("  stepLRStepSize: ");
                    builder.AppendLine($"{StepLRStepSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TrainingBatchSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  trainingBatchSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TrainingBatchSize))
                {
                    builder.Append("  trainingBatchSize: ");
                    builder.AppendLine($"{TrainingBatchSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationBatchSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationBatchSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationBatchSize))
                {
                    builder.Append("  validationBatchSize: ");
                    builder.AppendLine($"{ValidationBatchSize.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WarmupCosineLRCycles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  warmupCosineLRCycles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WarmupCosineLRCycles))
                {
                    builder.Append("  warmupCosineLRCycles: ");
                    builder.AppendLine($"'{WarmupCosineLRCycles.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WarmupCosineLRWarmupEpochs), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  warmupCosineLRWarmupEpochs: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WarmupCosineLRWarmupEpochs))
                {
                    builder.Append("  warmupCosineLRWarmupEpochs: ");
                    builder.AppendLine($"{WarmupCosineLRWarmupEpochs.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WeightDecay), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  weightDecay: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WeightDecay))
                {
                    builder.Append("  weightDecay: ");
                    builder.AppendLine($"'{WeightDecay.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ImageModelSettingsObjectDetection>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageModelSettingsObjectDetection>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ImageModelSettingsObjectDetection)} does not support writing '{options.Format}' format.");
            }
        }

        ImageModelSettingsObjectDetection IPersistableModel<ImageModelSettingsObjectDetection>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageModelSettingsObjectDetection>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeImageModelSettingsObjectDetection(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ImageModelSettingsObjectDetection)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ImageModelSettingsObjectDetection>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
