// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class ImageMetadata : IUtf8JsonSerializable, IJsonModel<ImageMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ImageMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ImageMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImageMetadata)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CurrentImageVersion))
            {
                writer.WritePropertyName("currentImageVersion"u8);
                writer.WriteStringValue(CurrentImageVersion);
            }
            if (Optional.IsDefined(LatestImageVersion))
            {
                writer.WritePropertyName("latestImageVersion"u8);
                writer.WriteStringValue(LatestImageVersion);
            }
            if (Optional.IsDefined(IsLatestOSImageVersion))
            {
                writer.WritePropertyName("isLatestOsImageVersion"u8);
                writer.WriteBooleanValue(IsLatestOSImageVersion.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ImageMetadata IJsonModel<ImageMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImageMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeImageMetadata(document.RootElement, options);
        }

        internal static ImageMetadata DeserializeImageMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string currentImageVersion = default;
            string latestImageVersion = default;
            bool? isLatestOSImageVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("currentImageVersion"u8))
                {
                    currentImageVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("latestImageVersion"u8))
                {
                    latestImageVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isLatestOsImageVersion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isLatestOSImageVersion = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ImageMetadata(currentImageVersion, latestImageVersion, isLatestOSImageVersion, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentImageVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  currentImageVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentImageVersion))
                {
                    builder.Append("  currentImageVersion: ");
                    if (CurrentImageVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentImageVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentImageVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LatestImageVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  latestImageVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LatestImageVersion))
                {
                    builder.Append("  latestImageVersion: ");
                    if (LatestImageVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LatestImageVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LatestImageVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsLatestOSImageVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isLatestOsImageVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsLatestOSImageVersion))
                {
                    builder.Append("  isLatestOsImageVersion: ");
                    var boolValue = IsLatestOSImageVersion.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ImageMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ImageMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        ImageMetadata IPersistableModel<ImageMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImageMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeImageMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ImageMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ImageMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
