// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine identity framework. </summary>
    internal readonly partial struct IdentityConfigurationType : IEquatable<IdentityConfigurationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IdentityConfigurationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IdentityConfigurationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManagedValue = "Managed";
        private const string AmlTokenValue = "AMLToken";
        private const string UserIdentityValue = "UserIdentity";

        /// <summary> Managed. </summary>
        public static IdentityConfigurationType Managed { get; } = new IdentityConfigurationType(ManagedValue);
        /// <summary> AMLToken. </summary>
        public static IdentityConfigurationType AmlToken { get; } = new IdentityConfigurationType(AmlTokenValue);
        /// <summary> UserIdentity. </summary>
        public static IdentityConfigurationType UserIdentity { get; } = new IdentityConfigurationType(UserIdentityValue);
        /// <summary> Determines if two <see cref="IdentityConfigurationType"/> values are the same. </summary>
        public static bool operator ==(IdentityConfigurationType left, IdentityConfigurationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IdentityConfigurationType"/> values are not the same. </summary>
        public static bool operator !=(IdentityConfigurationType left, IdentityConfigurationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IdentityConfigurationType"/>. </summary>
        public static implicit operator IdentityConfigurationType(string value) => new IdentityConfigurationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IdentityConfigurationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IdentityConfigurationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
