// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Defines a Sampling Algorithm that exhaustively generates every value combination in the space. </summary>
    public partial class GridSamplingAlgorithm : SamplingAlgorithm
    {
        /// <summary> Initializes a new instance of <see cref="GridSamplingAlgorithm"/>. </summary>
        public GridSamplingAlgorithm()
        {
            SamplingAlgorithmType = SamplingAlgorithmType.Grid;
        }

        /// <summary> Initializes a new instance of <see cref="GridSamplingAlgorithm"/>. </summary>
        /// <param name="samplingAlgorithmType"> [Required] The algorithm used for generating hyperparameter values, along with configuration properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GridSamplingAlgorithm(SamplingAlgorithmType samplingAlgorithmType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(samplingAlgorithmType, serializedAdditionalRawData)
        {
            SamplingAlgorithmType = samplingAlgorithmType;
        }
    }
}
