// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Forecasting Training related configuration. </summary>
    public partial class ForecastingTrainingSettings : MachineLearningTrainingSettings
    {
        /// <summary> Initializes a new instance of <see cref="ForecastingTrainingSettings"/>. </summary>
        public ForecastingTrainingSettings()
        {
            AllowedTrainingAlgorithms = new ChangeTrackingList<ForecastingModel>();
            BlockedTrainingAlgorithms = new ChangeTrackingList<ForecastingModel>();
        }

        /// <summary> Initializes a new instance of <see cref="ForecastingTrainingSettings"/>. </summary>
        /// <param name="isOnnxCompatibleModelsEnabled"> Flag for enabling onnx compatible models. </param>
        /// <param name="stackEnsembleSettings"> Stack ensemble settings for stack ensemble run. </param>
        /// <param name="isStackEnsembleEnabled"> Enable stack ensemble run. </param>
        /// <param name="isVoteEnsembleEnabled"> Enable voting ensemble run. </param>
        /// <param name="ensembleModelDownloadTimeout">
        /// During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        /// Configure this parameter with a higher value than 300 secs, if more time is needed.
        /// </param>
        /// <param name="isModelExplainabilityEnabled"> Flag to turn on explainability on best model. </param>
        /// <param name="isDnnTrainingEnabled"> Enable recommendation of DNN models. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="allowedTrainingAlgorithms"> Allowed models for forecasting task. </param>
        /// <param name="blockedTrainingAlgorithms"> Blocked models for forecasting task. </param>
        internal ForecastingTrainingSettings(bool? isOnnxCompatibleModelsEnabled, MachineLearningStackEnsembleSettings stackEnsembleSettings, bool? isStackEnsembleEnabled, bool? isVoteEnsembleEnabled, TimeSpan? ensembleModelDownloadTimeout, bool? isModelExplainabilityEnabled, bool? isDnnTrainingEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<ForecastingModel> allowedTrainingAlgorithms, IList<ForecastingModel> blockedTrainingAlgorithms) : base(isOnnxCompatibleModelsEnabled, stackEnsembleSettings, isStackEnsembleEnabled, isVoteEnsembleEnabled, ensembleModelDownloadTimeout, isModelExplainabilityEnabled, isDnnTrainingEnabled, serializedAdditionalRawData)
        {
            AllowedTrainingAlgorithms = allowedTrainingAlgorithms;
            BlockedTrainingAlgorithms = blockedTrainingAlgorithms;
        }

        /// <summary> Allowed models for forecasting task. </summary>
        [WirePath("allowedTrainingAlgorithms")]
        public IList<ForecastingModel> AllowedTrainingAlgorithms { get; set; }
        /// <summary> Blocked models for forecasting task. </summary>
        [WirePath("blockedTrainingAlgorithms")]
        public IList<ForecastingModel> BlockedTrainingAlgorithms { get; set; }
    }
}
