// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Primary metrics for Forecasting task. </summary>
    public readonly partial struct ForecastingPrimaryMetric : IEquatable<ForecastingPrimaryMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ForecastingPrimaryMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ForecastingPrimaryMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SpearmanCorrelationValue = "SpearmanCorrelation";
        private const string NormalizedRootMeanSquaredErrorValue = "NormalizedRootMeanSquaredError";
        private const string R2ScoreValue = "R2Score";
        private const string NormalizedMeanAbsoluteErrorValue = "NormalizedMeanAbsoluteError";

        /// <summary> The Spearman's rank coefficient of correlation is a non-parametric measure of rank correlation. </summary>
        public static ForecastingPrimaryMetric SpearmanCorrelation { get; } = new ForecastingPrimaryMetric(SpearmanCorrelationValue);
        /// <summary> The Normalized Root Mean Squared Error (NRMSE) the RMSE facilitates the comparison between models with different scales. </summary>
        public static ForecastingPrimaryMetric NormalizedRootMeanSquaredError { get; } = new ForecastingPrimaryMetric(NormalizedRootMeanSquaredErrorValue);
        /// <summary> The R2 score is one of the performance evaluation measures for forecasting-based machine learning models. </summary>
        public static ForecastingPrimaryMetric R2Score { get; } = new ForecastingPrimaryMetric(R2ScoreValue);
        /// <summary> The Normalized Mean Absolute Error (NMAE) is a validation metric to compare the Mean Absolute Error (MAE) of (time) series with different scales. </summary>
        public static ForecastingPrimaryMetric NormalizedMeanAbsoluteError { get; } = new ForecastingPrimaryMetric(NormalizedMeanAbsoluteErrorValue);
        /// <summary> Determines if two <see cref="ForecastingPrimaryMetric"/> values are the same. </summary>
        public static bool operator ==(ForecastingPrimaryMetric left, ForecastingPrimaryMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ForecastingPrimaryMetric"/> values are not the same. </summary>
        public static bool operator !=(ForecastingPrimaryMetric left, ForecastingPrimaryMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ForecastingPrimaryMetric"/>. </summary>
        public static implicit operator ForecastingPrimaryMetric(string value) => new ForecastingPrimaryMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ForecastingPrimaryMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ForecastingPrimaryMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
