// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine forecast horizon selection mode. </summary>
    internal readonly partial struct ForecastHorizonMode : IEquatable<ForecastHorizonMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ForecastHorizonMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ForecastHorizonMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "Auto";
        private const string CustomValue = "Custom";

        /// <summary> Forecast horizon to be determined automatically. </summary>
        public static ForecastHorizonMode Auto { get; } = new ForecastHorizonMode(AutoValue);
        /// <summary> Use the custom forecast horizon. </summary>
        public static ForecastHorizonMode Custom { get; } = new ForecastHorizonMode(CustomValue);
        /// <summary> Determines if two <see cref="ForecastHorizonMode"/> values are the same. </summary>
        public static bool operator ==(ForecastHorizonMode left, ForecastHorizonMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ForecastHorizonMode"/> values are not the same. </summary>
        public static bool operator !=(ForecastHorizonMode left, ForecastHorizonMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ForecastHorizonMode"/>. </summary>
        public static implicit operator ForecastHorizonMode(string value) => new ForecastHorizonMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ForecastHorizonMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ForecastHorizonMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
